/*
 * $Id: DatabindingTestCase.java 21151 2011-01-31 21:53:23Z dzapata $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.cxf;

import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;

public class DatabindingTestCase extends DynamicPortTestCase
{

    public void testEchoWsdl() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.request(((InboundEndpoint) client.getMuleContext().getRegistry()
                        .lookupObject("httpInbound")).getAddress() + "?wsdl", 5000);
        assertNotNull(result.getPayload());
    }

    protected String getConfigResources()
    {
        return "databinding-conf.xml";
    }

    @Override
    protected int getNumPortsToFind()
    {
        return 1;
    }

}
