/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.policy.AroundPolicy;
import org.mule.api.processor.policy.PolicyInvocation;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.simple.StringAppendTransformer;

public class PolicyTestCase
extends AbstractMuleTestCase {
    public void testSinglePolicy() throws Exception {
        TestPolicy ap = new TestPolicy("test around policy");
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new StringAppendTransformer("first"), new StringAppendTransformer(" second")});
        this.initialiseObject(chain);
        PolicyTestCase.assertEquals((String)"No policies should have been registered.", (int)0, (int)chain.getPolicies().list().size());
        chain.getPolicies().add((AroundPolicy)ap);
        PolicyTestCase.assertSame((String)"Policy has not been registered.", (Object)ap, chain.getPolicies().list().iterator().next());
        System.out.println(chain);
        MuleEvent result = chain.process(PolicyTestCase.getTestEvent("payload "));
        PolicyTestCase.assertNotNull((Object)result);
        MuleMessage message = result.getMessage();
        PolicyTestCase.assertNotNull((Object)message);
        PolicyTestCase.assertEquals((Object)"payload {before} first second {after}", (Object)message.getPayload());
        AroundPolicy policy = chain.getPolicies().remove(ap.getName());
        PolicyTestCase.assertSame((String)"Wrong policy returned?", (Object)ap, (Object)policy);
        PolicyTestCase.assertEquals((String)"No policies should have been registered.", (int)0, (int)chain.getPolicies().list().size());
    }

    public void testMultiplePolicies() throws Exception {
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{new StringAppendTransformer("first"), new StringAppendTransformer(" second")});
        this.initialiseObject(chain);
        PolicyTestCase.assertEquals((String)"No policies should have been registered.", (int)0, (int)chain.getPolicies().list().size());
        TestPolicy policy1 = new TestPolicy("test around policy 1");
        chain.getPolicies().add((AroundPolicy)policy1);
        TestPolicy policy2 = new TestPolicy("test around policy 2");
        chain.getPolicies().add((AroundPolicy)policy2);
        PolicyTestCase.assertEquals((String)"Wrong policies count.", (int)2, (int)chain.getPolicies().list().size());
        System.out.println(chain);
        MuleEvent result = chain.process(PolicyTestCase.getTestEvent("payload "));
        PolicyTestCase.assertNotNull((Object)result);
        MuleMessage message = result.getMessage();
        PolicyTestCase.assertNotNull((Object)message);
        PolicyTestCase.assertEquals((Object)"payload {before} {before} first second {after} {after}", (Object)message.getPayload());
        AroundPolicy policy = chain.getPolicies().remove(policy1.getName());
        PolicyTestCase.assertSame((String)"Wrong policy returned?", (Object)policy1, (Object)policy);
        chain.getPolicies().remove(policy2.getName());
        PolicyTestCase.assertEquals((String)"No policies should have been registered.", (int)0, (int)chain.getPolicies().list().size());
    }

    public void testDuplicateName() throws Exception {
        MessageProcessorChain chain = DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[0]);
        chain.getPolicies().add((AroundPolicy)new TestPolicy("test"));
        try {
            chain.getPolicies().add((AroundPolicy)new TestPolicy("test"));
            PolicyTestCase.fail((String)"Should've thrown an exception, no duplicates allowed");
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
    }

    private static class TestPolicy
    implements AroundPolicy {
        private String name;

        public TestPolicy(String name) {
            this.name = name;
        }

        public MuleEvent invoke(PolicyInvocation invocation) throws MuleException {
            new StringAppendTransformer("{before} ").process(invocation.getEvent());
            MuleEvent result = invocation.proceed();
            new StringAppendTransformer(" {after}").process(invocation.getEvent());
            return result;
        }

        public String getName() {
            return this.name;
        }
    }
}

