/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Parameterized;
import org.mule.util.FileUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleParameterized
extends Parameterized {
    private static ArrayList<String> excludedTests = new ArrayList();
    protected static transient Log logger = LogFactory.getLog(MuleParameterized.class);
    private static Filter excludeFilter = new Filter(){

        public boolean shouldRun(Description description) {
            for (String excludedTest : excludedTests) {
                if (!((Description)description.getChildren().get(0)).toString().contains(excludedTest)) continue;
                logger.info((Object)("skipping test : " + ((Description)description.getChildren().get(0)).toString()));
                return false;
            }
            return true;
        }

        public String describe() {
            return "excludes tests from mule-test-exclusions.txt";
        }
    };

    public MuleParameterized(Class<?> klass) throws Throwable {
        super(klass);
        this.getExcluded();
        try {
            this.filter(excludeFilter);
        }
        catch (NoTestsRemainException noTestsRemainException) {
            // empty catch block
        }
    }

    public void getExcluded() {
        try {
            URL fileUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("mule-test-exclusions.txt");
            if (fileUrl != null) {
                URI fileUri = new URI(StringUtils.removeStart((String)fileUrl.toString(), (String)"jar:"));
                LineIterator lines = FileUtils.lineIterator((File)FileUtils.newFile((URI)fileUri));
                ArrayList<String> s = new ArrayList<String>();
                while (lines.hasNext()) {
                    String line = StringUtils.trimToEmpty((String)((String)lines.next()));
                    if (line.startsWith("#") || line.equals("") || line.length() <= 0) continue;
                    s.add(line);
                    logger.info((Object)("adding test to the list of exclusions : " + line));
                }
                excludedTests = s;
            } else {
                logger.info((Object)"did not find test exclusions file");
            }
        }
        catch (IOException ioex) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

