/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.ServiceRegistry;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.api.MuleRuntimeException;
import org.mule.config.PreferredObjectSelector;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.AppBloodhound;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.module.launcher.descriptor.EmptyApplicationDescriptor;
import org.mule.module.launcher.descriptor.PropertiesDescriptorParser;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.PropertiesUtils;

public class DefaultAppBloodhound
implements AppBloodhound {
    protected Map<String, DescriptorParser> parserRegistry = new HashMap<String, DescriptorParser>();

    public DefaultAppBloodhound() {
        this.parserRegistry.put("properties", new PropertiesDescriptorParser());
        Iterator<DescriptorParser> it = ServiceRegistry.lookupProviders(DescriptorParser.class);
        MultiValueMap overrides = new MultiValueMap();
        while (it.hasNext()) {
            DescriptorParser parser = it.next();
            overrides.put((Object)parser.getSupportedFormat(), (Object)parser);
        }
        this.mergeParserOverrides((MultiMap)overrides);
    }

    public ApplicationDescriptor fetch(String appName) throws IOException {
        ApplicationDescriptor desc;
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        File appDir = new File(appsDir, appName);
        if (!appDir.exists()) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Application directory does not exist: '%s'", appDir)));
        }
        Collection deployFiles = FileUtils.listFiles((File)appDir, (IOFileFilter)new WildcardFileFilter("mule-deploy.*"), null);
        if (deployFiles.size() > 1) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("More than one mule-deploy descriptors found in application '%s'", appName)));
        }
        if (deployFiles.isEmpty()) {
            desc = new EmptyApplicationDescriptor(appName);
        } else {
            File descriptorFile = (File)deployFiles.iterator().next();
            String ext = FilenameUtils.getExtension((String)descriptorFile.getName());
            DescriptorParser descriptorParser = this.parserRegistry.get(ext);
            if (descriptorParser == null) {
                throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Unsupported deployment descriptor format for app '%s': %s", appName, ext)));
            }
            desc = descriptorParser.parse(descriptorFile);
            desc.setAppName(appName);
        }
        File appPropsFile = new File(appDir, "mule-app.properties");
        if (appPropsFile.exists() && appPropsFile.canRead()) {
            Properties props = PropertiesUtils.loadProperties((URL)appPropsFile.toURI().toURL());
            HashMap<String, String> m = new HashMap<String, String>(props.size());
            for (Object key : props.keySet()) {
                m.put(key.toString(), props.getProperty(key.toString()));
            }
            desc.setAppProperties(m);
        }
        return desc;
    }

    protected void mergeParserOverrides(MultiMap overrides) {
        PreferredObjectSelector selector = new PreferredObjectSelector();
        for (Map.Entry<String, DescriptorParser> entry : this.parserRegistry.entrySet()) {
            Collection candidates = (Collection)overrides.get((Object)entry.getKey());
            if (candidates == null) continue;
            this.parserRegistry.put(entry.getKey(), (DescriptorParser)selector.select(candidates.iterator()));
        }
    }
}

