/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust10Builder
implements AssertionBuilder {
    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        if ((element = DOMUtils.getFirstElement((Node)element)) == null || !element.getLocalName().equals("Policy")) {
            throw new IllegalArgumentException("Trust10 assertion doesn't contain any Policy");
        }
        Trust10 trust10 = new Trust10(SP11Constants.INSTANCE);
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.MUST_SUPPORT_CLIENT_CHALLENGE) != null) {
            trust10.setMustSupportClientChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.MUST_SUPPORT_SERVER_CHALLENGE) != null) {
            trust10.setMustSupportServerChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.REQUIRE_CLIENT_ENTROPY) != null) {
            trust10.setRequireClientEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.REQUIRE_SERVER_ENTROPY) != null) {
            trust10.setRequireServerEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP11Constants.MUST_SUPPORT_ISSUED_TOKENS) != null) {
            trust10.setMustSupportIssuedTokens(true);
        }
        return trust10;
    }

    public List<QName> getKnownElements() {
        return Collections.singletonList(SP11Constants.TRUST_10);
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

