/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.NullPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMuleMessageFactory
implements MuleMessageFactory {
    protected MuleContext muleContext;

    public AbstractMuleMessageFactory(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public MuleMessage create(Object transportMessage, String encoding) throws Exception {
        return this.create(transportMessage, null, encoding);
    }

    @Override
    public MuleMessage create(Object transportMessage, MuleMessage previousMessage, String encoding) throws Exception {
        if (transportMessage == null) {
            return new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
        }
        if (!this.isTransportMessageTypeSupported(transportMessage)) {
            throw new MessageTypeNotSupportedException(transportMessage, this.getClass());
        }
        Object payload = this.extractPayload(transportMessage, encoding);
        DefaultMuleMessage message = previousMessage != null ? new DefaultMuleMessage(payload, previousMessage, this.muleContext) : new DefaultMuleMessage(payload, this.muleContext);
        message.setEncoding(encoding);
        this.addProperties(message, transportMessage);
        this.addAttachments(message, transportMessage);
        return message;
    }

    protected abstract Class<?>[] getSupportedTransportMessageTypes();

    protected abstract Object extractPayload(Object var1, String var2) throws Exception;

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
    }

    protected void addAttachments(DefaultMuleMessage message, Object transportMessage) throws Exception {
    }

    private boolean isTransportMessageTypeSupported(Object transportMessage) {
        Class<?> transportMessageType = transportMessage.getClass();
        boolean match = false;
        for (Class<?> type : this.getSupportedTransportMessageTypes()) {
            if (!type.isAssignableFrom(transportMessageType)) continue;
            match = true;
            break;
        }
        return match;
    }
}

