/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.routing.filters.WildcardFilter;
import org.mule.util.MapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    public static final Object[] NO_ARGS = new Object[0];
    public static final Class<?>[] NO_ARGS_TYPE = new Class[0];
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);

    public static boolean isConcrete(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz may not be null");
        }
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static URL getResource(final String resourceName, final Class<?> callingClass) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.getResource(resourceName) : null;
            }
        });
        if (url == null) {
            url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return ClassUtils.class.getClassLoader().getResource(resourceName);
                }
            });
        }
        if (url == null) {
            url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    return callingClass.getClassLoader().getResource(resourceName);
                }
            });
        }
        return url;
    }

    public static Enumeration<URL> getResources(final String resourceName, final Class<?> callingClass) {
        Enumeration<URL> enumeration = AccessController.doPrivileged(new PrivilegedAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return cl != null ? cl.getResources(resourceName) : null;
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
        if (enumeration == null) {
            enumeration = AccessController.doPrivileged(new PrivilegedAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() {
                    try {
                        return ClassUtils.class.getClassLoader().getResources(resourceName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        if (enumeration == null) {
            enumeration = AccessController.doPrivileged(new PrivilegedAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() {
                    try {
                        return callingClass.getClassLoader().getResources(resourceName);
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            });
        }
        return enumeration;
    }

    public static Class loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, callingClass, Object.class);
    }

    public static <T extends Class> T loadClass(final String className, final Class<?> callingClass, T type) throws ClassNotFoundException {
        if (className.length() <= 8 && primitiveTypeNameMap.containsKey(className)) {
            return (T)primitiveTypeNameMap.get(className);
        }
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return cl != null ? cl.loadClass(className) : null;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        });
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return ClassUtils.class.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            clazz = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        return callingClass.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
            });
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        if (type.isAssignableFrom(clazz)) {
            return (T)clazz;
        }
        throw new IllegalArgumentException(String.format("Loaded class '%s' is not assignable from type '%s'", clazz.getName(), type.getName()));
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass(className);
    }

    public static Class<?> initializeClass(Class<?> clazz) {
        try {
            return ClassUtils.getClass((String)clazz.getName(), (boolean)true);
        }
        catch (ClassNotFoundException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    public static <T> T instanciateClass(Class<? extends T> clazz, Object ... constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassUtils.getConstructor(clazz, args)) == null) {
            ctor = ClassUtils.getConstructor(clazz, ClassUtils.wrappersToPrimitives(args));
        }
        if (ctor == null) {
            StringBuffer argsString = new StringBuffer(100);
            for (Class arg : args) {
                argsString.append(arg.getName()).append(", ");
            }
            throw new NoSuchMethodException("could not find constructor on class: " + clazz + ", with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    public static Object instanciateClass(String name, Object ... constructorArgs) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ClassUtils.instanciateClass(name, constructorArgs, (ClassLoader)null);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs, Class<?> callingClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassUtils.loadClass(name, callingClass);
        return ClassUtils.instanciateClass(clazz, constructorArgs);
    }

    public static Object instanciateClass(String name, Object[] constructorArgs, ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = classLoader != null ? ClassUtils.loadClass(name, classLoader) : ClassUtils.loadClass(name, ClassUtils.class);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return ClassUtils.instanciateClass(clazz, constructorArgs);
    }

    public static Class<?>[] getParameterTypes(Object bean, String methodName) {
        if (!methodName.startsWith("set")) {
            methodName = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        }
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            return methods[i].getParameterTypes();
        }
        return new Class[0];
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            if (parameterTypes == null) {
                return methods[i];
            }
            if (!ClassUtils.compare(methods[i].getParameterTypes(), parameterTypes, true)) continue;
            return methods[i];
        }
        return null;
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        return ClassUtils.getConstructor(clazz, paramTypes, false);
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes, boolean exactMatch) {
        Constructor<?>[] ctors = clazz.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Class<?>[] types = ctors[i].getParameterTypes();
            if (types.length != paramTypes.length) continue;
            int matchCount = 0;
            for (int x = 0; x < types.length; ++x) {
                if (paramTypes[x] == null) {
                    ++matchCount;
                    continue;
                }
                if (exactMatch) {
                    if (!paramTypes[x].equals(types[x]) && !types[x].equals(paramTypes[x])) continue;
                    ++matchCount;
                    continue;
                }
                if (!paramTypes[x].isAssignableFrom(types[x]) && !types[x].isAssignableFrom(paramTypes[x])) continue;
                ++matchCount;
            }
            if (matchCount != types.length) continue;
            return ctors[i];
        }
        return null;
    }

    public static List<Method> getSatisfiableMethods(Class<?> implementation, Class<?>[] parameterTypes, boolean voidOk, boolean matchOnObject, Set<String> ignoredMethodNames) {
        return ClassUtils.getSatisfiableMethods(implementation, parameterTypes, voidOk, matchOnObject, ignoredMethodNames, null);
    }

    public static List<Method> getSatisfiableMethods(Class<?> implementation, Class<?>[] parameterTypes, boolean voidOk, boolean matchOnObject, Collection<String> ignoredMethodNames, WildcardFilter filter) {
        ArrayList<Method> result = new ArrayList<Method>();
        if (ignoredMethodNames == null) {
            ignoredMethodNames = Collections.emptySet();
        }
        Method[] methods = implementation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String returnType;
            Class[] methodParams;
            Method method = methods[i];
            if (filter != null && filter.accept(method.getName()) || !ClassUtils.compare(methodParams = method.getParameterTypes(), parameterTypes, matchOnObject) || ignoredMethodNames.contains(method.getName()) || (!(returnType = method.getReturnType().getName()).equals("void") || !voidOk) && returnType.equals("void")) continue;
            result.add(method);
        }
        return result;
    }

    public static List<Method> getSatisfiableMethodsWithReturnType(Class implementation, Class returnType, boolean matchOnObject, Set<String> ignoredMethodNames) {
        ArrayList<Method> result = new ArrayList<Method>();
        if (ignoredMethodNames == null) {
            ignoredMethodNames = Collections.emptySet();
        }
        Method[] methods = implementation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> returns = method.getReturnType();
            if (!ClassUtils.compare(new Class[]{returns}, new Class[]{returnType}, matchOnObject) || ignoredMethodNames.contains(method.getName())) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassOnPath(String className, Class currentClass) {
        try {
            return ClassUtils.loadClass(className, currentClass) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?>[] getClassTypes(Object object) {
        Class[] types;
        if (object == null) {
            return NO_ARGS_TYPE;
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            if (objects.length == 0) {
                return NO_ARGS_TYPE;
            }
            types = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                Object o = objects[i];
                if (o == null) continue;
                types[i] = o.getClass();
            }
        } else {
            types = new Class[]{object.getClass()};
        }
        return types;
    }

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static boolean compare(Class[] c1, Class[] c2, boolean matchOnObject) {
        if (c1.length != c2.length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i] == null || c2[i] == null) {
                return false;
            }
            if (c1[i].equals(Object.class) && !matchOnObject) {
                return false;
            }
            if (c1[i].isAssignableFrom(c2[i])) continue;
            return false;
        }
        return true;
    }

    public static Class wrapperToPrimitive(Class wrapper) {
        return (Class)MapUtils.getObject(wrapperToPrimitiveMap, (Object)wrapper, (Object)wrapper);
    }

    public static Class[] wrappersToPrimitives(Class[] wrappers) {
        if (wrappers == null) {
            return null;
        }
        if (wrappers.length == 0) {
            return wrappers;
        }
        Class[] primitives = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            primitives[i] = (Class)MapUtils.getObject(wrapperToPrimitiveMap, (Object)wrappers[i], (Object)wrappers[i]);
        }
        return primitives;
    }

    public static String getSimpleName(Class clazz) {
        if (null == clazz) {
            return "null";
        }
        return ClassUtils.classNameHelper(new BufferedReader(new CharArrayReader(clazz.getName().toCharArray())));
    }

    private static String classNameHelper(Reader encodedName) {
        try {
            encodedName.mark(1);
            switch (encodedName.read()) {
                case -1: {
                    return "null";
                }
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 68: {
                    return "double";
                }
                case 70: {
                    return "float";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 83: {
                    return "short";
                }
                case 91: {
                    return ClassUtils.classNameHelper(encodedName) + "[]";
                }
                case 76: {
                    return ClassUtils.shorten(new BufferedReader(encodedName).readLine());
                }
            }
            encodedName.reset();
            return ClassUtils.shorten(new BufferedReader(encodedName).readLine());
        }
        catch (IOException e) {
            return "unknown type: " + e.getMessage();
        }
    }

    private static String shorten(String clazz) {
        if (null != clazz && clazz.endsWith(";")) {
            clazz = clazz.substring(0, clazz.length() - 1);
        }
        if (null != clazz && clazz.lastIndexOf(".") > -1) {
            clazz = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
        }
        return clazz;
    }

    public static boolean equal(Object a, Object b) {
        if (null == a) {
            return null == b;
        }
        return null != b && a.equals(b);
    }

    public static int hash(Object[] state) {
        int hash = 0;
        for (int i = 0; i < state.length; ++i) {
            hash = hash * 31 + (null == state[i] ? 0 : state[i].hashCode());
        }
        return hash;
    }

    public static void addLibrariesToClasspath(List urls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader sys = ClassLoader.getSystemClassLoader();
        if (!(sys instanceof URLClassLoader)) {
            throw new IllegalArgumentException("PANIC: Mule has been started with an unsupported classloader: " + sys.getClass().getName() + ". " + "Please report this error to user<at>mule<dot>codehaus<dot>org");
        }
        URLClassLoader sysCl = (URLClassLoader)sys;
        Class<URLClassLoader> refClass = URLClassLoader.class;
        Method methodAddUrl = refClass.getDeclaredMethod("addURL", URL.class);
        methodAddUrl.setAccessible(true);
        for (URL url : urls) {
            methodAddUrl.invoke((Object)sysCl, url);
        }
    }

    public static URL getClassPathRoot(Class clazz) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        return cs != null ? cs.getLocation() : null;
    }

    static {
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Void.TYPE, Void.TYPE);
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(wrapperToPrimitiveMap.values());
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

