/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import java.util.Map;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Transition;
import org.jbpm.api.task.Assignable;
import org.jbpm.api.task.Task;
import org.jbpm.jpdl.internal.activity.JpdlExternalActivity;
import org.jbpm.pvm.internal.cal.Duration;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskActivityStart;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ObservableElement;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.AssignableDefinitionImpl;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneDefinitionImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivity
extends JpdlExternalActivity {
    private static final long serialVersionUID = 1L;
    protected TaskDefinitionImpl taskDefinition;

    public void execute(ActivityExecution execution) {
        this.execute((ExecutionImpl)execution);
    }

    public void execute(ExecutionImpl execution) {
        DbSession dbSession = (DbSession)EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = dbSession.createTask();
        task.setTaskDefinition(this.taskDefinition);
        task.setExecution(execution);
        task.setProcessInstance(execution.getProcessInstance());
        task.setSignalling(true);
        if (this.taskDefinition.getName() != null) {
            task.setName(this.taskDefinition.getName());
        } else {
            task.setName(execution.getActivityName());
        }
        Expression descriptionExpression = this.taskDefinition.getDescription();
        if (descriptionExpression != null) {
            String description = (String)descriptionExpression.evaluate((Task)task);
            task.setDescription(description);
        }
        task.setPriority(this.taskDefinition.getPriority());
        task.setFormResourceName(this.taskDefinition.getFormResourceName());
        String dueDateDescription = this.taskDefinition.getDueDateDescription();
        if (dueDateDescription != null) {
            task.setDuedate(Duration.calculateDueDate((String)dueDateDescription));
        }
        dbSession.save((Object)task);
        SwimlaneDefinitionImpl swimlaneDefinition = this.taskDefinition.getSwimlaneDefinition();
        if (swimlaneDefinition != null) {
            SwimlaneImpl swimlane = execution.getInitializedSwimlane(swimlaneDefinition);
            task.setSwimlane(swimlane);
            task.setAssignee(swimlane.getAssignee());
            for (ParticipationImpl participant : swimlane.getParticipations()) {
                task.addParticipation(participant.getUserId(), participant.getGroupId(), participant.getType());
            }
        }
        execution.initializeAssignments((AssignableDefinitionImpl)this.taskDefinition, (Assignable)task);
        HistoryEvent.fire((HistoryEvent)new TaskActivityStart(task), (ExecutionImpl)execution);
        execution.waitForSignal();
    }

    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        this.signal((ExecutionImpl)execution, signalName, parameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void signal(ExecutionImpl execution, String signalName, Map<String, ?> parameters) throws Exception {
        ActivityImpl activity = execution.getActivity();
        if (parameters != null) {
            execution.setVariables(parameters);
        }
        execution.fire(signalName, (ObservableElement)activity);
        DbSession taskDbSession = (DbSession)EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl task = taskDbSession.findTaskByExecution((Execution)execution);
        if (task != null) {
            task.setSignalling(false);
        }
        TransitionImpl transition = null;
        List outgoingTransitions = activity.getOutgoingTransitions();
        if (outgoingTransitions == null || outgoingTransitions.isEmpty()) return;
        boolean noOutcomeSpecified = "jbpm_no_task_outcome_specified_jbpm".equals(signalName);
        transition = noOutcomeSpecified && activity.findOutgoingTransition(signalName) == null ? activity.findOutgoingTransition(null) : activity.findOutgoingTransition(signalName);
        if (transition == null) {
            if (signalName == null) {
                throw new JbpmException("No unnamed transitions were found for the task '" + this.getTaskDefinition().getName() + "'");
            }
            if (!noOutcomeSpecified) throw new JbpmException("No transition named '" + signalName + "' was found.");
            if (outgoingTransitions.size() != 1) throw new JbpmException("No unnamed transitions were found for the task '" + this.getTaskDefinition().getName() + "'");
            transition = (Transition)outgoingTransitions.get(0);
        }
        if (task != null && !task.isCompleted()) {
            task.skip(transition.getName());
        }
        if (transition == null) return;
        execution.take((Transition)transition);
    }

    public TaskDefinitionImpl getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
    }
}

