/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.auth;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.ParamFactory;
import org.ibeans.impl.support.util.UriParamFilter;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public class OAuthAuthorizationHeaderParamFactory
implements ParamFactory {
    public String create(String paramName, boolean optional, InvocationContext invocationContext) throws URISyntaxException {
        Properties p = new Properties();
        p.putAll(invocationContext.getIBeanConfig().getPropertyParams());
        UriParamFilter filter = new UriParamFilter();
        String requestUrl = filter.filterParamsByValue(invocationContext.getParsedCallUri(), "null.param");
        String accessTokenString = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.access.token");
        String accessSecretString = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.access.secret");
        if (accessTokenString == null && accessSecretString == null) {
            return null;
        }
        if (accessTokenString == null) {
            throw new RuntimeException("No access token found for key: oauth.access.token");
        }
        if (accessSecretString == null) {
            throw new RuntimeException("No secret key found for key: oauth.access.secret");
        }
        String consumerKeyString = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.consumer.key");
        if (consumerKeyString == null) {
            throw new RuntimeException("No consumer key found for key: oauth.consumer.key");
        }
        String consumerSecretString = (String)invocationContext.getIBeanConfig().getPropertyParams().get("oauth.consumer.secret");
        if (consumerSecretString == null) {
            throw new RuntimeException("No consumer secret key found for key: oauth.consumer.secret");
        }
        String httpMethod = (String)invocationContext.getIBeanConfig().getPropertyParams().get("http.method");
        if (httpMethod == null) {
            throw new RuntimeException("When using oAuth the HTTP method must be defined per call");
        }
        OAuthService service = new ServiceBuilder().provider(TwitterApi.class).apiKey(consumerKeyString).apiSecret(consumerSecretString).build();
        Token accessToken = new Token(accessTokenString, accessSecretString);
        OAuthRequest request = new OAuthRequest(Verb.valueOf(httpMethod.toUpperCase()), requestUrl);
        for (Map.Entry<String, Object> entry : invocationContext.getIBeanConfig().getPayloadParams().entrySet()) {
            request.addBodyParameter(entry.getKey().toString(), entry.getValue().toString());
        }
        service.signRequest(accessToken, request);
        String authHeader = (String)request.getHeaders().get(paramName);
        return authHeader;
    }
}

