/*
 * $Id: MCPNamespaceHandler.java 21144 2011-01-28 01:02:36Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.mcp.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.specific.BridgeDefinitionParser;
import org.mule.config.spring.parsers.specific.SimpleServiceDefinitionParser;
import org.mule.config.spring.parsers.specific.ValidatorDefinitionParser;
import org.mule.module.ws.config.spring.parsers.specific.WSProxyDefinitionParser;

/**
 * Registers a Bean Definition Parser for handling <code><mcp:*></code> elements.
 */
public class MCPNamespaceHandler extends AbstractMuleNamespaceHandler
{
    public void init()
    {
        // Flow Constructs
        registerBeanDefinitionParser("web-service-proxy", new WSProxyDefinitionParser());
        registerBeanDefinitionParser("simple-service", new SimpleServiceDefinitionParser());
        registerBeanDefinitionParser("bridge", new BridgeDefinitionParser());
        registerBeanDefinitionParser("validator", new ValidatorDefinitionParser());
        
    }
}
