/*
 * $Id: AxisConnectorJmsEndpointFormatTestCase.java 19327 2010-09-03 13:09:47Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.soap.axis;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.DispatchException;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

import org.apache.axis.AxisFault;

public class AxisConnectorJmsEndpointFormatTestCase extends FunctionalTestCase
{

    public void testAxisOverJmsWithQueueNameSameAsComponentName() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("componentName", new DefaultMuleMessage("test1", muleContext));
        assertNotNull(result.getPayload());
        assertEquals("test1", result.getPayloadAsString());
    }
    
    public void testAxisOverJmsWithQueueNameDifferentFromComponentName() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.send("soapActionDefined", new DefaultMuleMessage("test2", muleContext));
        assertNotNull(result.getPayload());
        assertEquals("test2", result.getPayloadAsString());
    }
    
    public void testAxisOverJmsWithoutSettingMethodOnEndpoint() throws Exception
    {
        try
        {
            new MuleClient(muleContext).send("noMethodDefined", new DefaultMuleMessage("test3", muleContext));
            fail("Exception expected");
        }
        catch (DispatchException e)
        {
            assertTrue(e.getMessage().startsWith("Cannot invoke WS call without an Operation."));
        }
    }
    
    public void testAxisOverJmsWithoutSettingSoapAction() throws Exception
    {
        try
        {
            new MuleClient(muleContext).send("noSoapActionDefined", new DefaultMuleMessage("test4", muleContext));
            fail("Exception expected");
        }
        catch (DispatchException e)
        {
            assertTrue(e.getCause() instanceof AxisFault);
            assertTrue(e.getCause().getMessage().startsWith("The AXIS engine could not find a target service to invoke!"));
        }
    }
    
    protected String getConfigResources()
    {
        return "axis-jms-endpoint-format-config.xml";
    }

}
