/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleEndpointObserver
implements MessageObserver {
    public static final String ENDPOINTS = "multipleEndpointObserver.endpoints";
    protected Bus bus;
    protected List<Interceptor<? extends Message>> bindingInterceptors = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    protected List<Interceptor<? extends Message>> routingInterceptors = new CopyOnWriteArrayList<Interceptor<? extends Message>>();
    private Set<Endpoint> endpoints = new CopyOnWriteArraySet<Endpoint>();

    public MultipleEndpointObserver(Bus bus) {
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        try {
            Exchange exchange = message.getExchange();
            if (exchange == null) {
                exchange = new ExchangeImpl();
                exchange.setInMessage(message);
                message.setExchange(exchange);
            }
            message = this.createMessage(message);
            message.setExchange(exchange);
            exchange.setInMessage(message);
            this.setExchangeProperties(exchange, message);
            PhaseInterceptorChain chain = this.createChain();
            message.setInterceptorChain((InterceptorChain)chain);
            chain.add((Collection)this.bus.getInInterceptors());
            if (this.bindingInterceptors != null) {
                chain.add(this.bindingInterceptors);
            }
            if (this.routingInterceptors != null) {
                chain.add(this.routingInterceptors);
            }
            if (this.endpoints != null) {
                exchange.put((Object)ENDPOINTS, this.endpoints);
            }
            chain.doIntercept(message);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)origBus);
        }
    }

    protected Message createMessage(Message message) {
        return message;
    }

    protected PhaseInterceptorChain createChain() {
        PhaseInterceptorChain chain = new PhaseInterceptorChain(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases());
        return chain;
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Bus.class, (Object)this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
    }

    public List<Interceptor<? extends Message>> getBindingInterceptors() {
        return this.bindingInterceptors;
    }

    public List<Interceptor<? extends Message>> getRoutingInterceptors() {
        return this.routingInterceptors;
    }

    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }
}

