/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.jndi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.mule.api.MuleException;
import org.mule.transport.jms.jndi.AbstractJndiNameResolver;

public class CachedJndiNameResolver
extends AbstractJndiNameResolver {
    protected Map<String, Object> cache;

    public Object lookup(String name) throws NamingException {
        Object result = this.findInCache(name);
        if (result == null) {
            result = this.findInContext(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findInContext(String name) throws NamingException {
        Object object;
        Context jndiContext = this.createInitialContext();
        try {
            Object result = jndiContext.lookup(name);
            if (result != null) {
                this.cache.put(name, result);
            }
            object = result;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            jndiContext.close();
            throw throwable;
        }
        jndiContext.close();
        return object;
    }

    private Object findInCache(String name) {
        Object result = null;
        if (name != null) {
            result = this.cache.get(name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Object: " + name + " was %sfound in the cache", result == null ? "not " : ""));
            }
        }
        return result;
    }

    public void initialise() {
        this.cache = new ConcurrentHashMap<String, Object>();
    }

    public void stop() throws MuleException {
        this.cache.clear();
    }
}

