/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.redelivery;

import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.jms.redelivery.AbstractRedeliveryHandler;
import org.mule.transport.jms.redelivery.MessageRedeliveredException;

public class CountingRedeliveryHandler
extends AbstractRedeliveryHandler {
    protected static final Log logger = LogFactory.getLog(CountingRedeliveryHandler.class);
    private Map<String, Integer> messages = Collections.synchronizedMap(new LRUMap(256));

    public void handleRedelivery(Message message, ImmutableEndpoint endpoint, FlowConstruct flow) throws JMSException, MuleException {
        int connectorRedelivery = this.connector.getMaxRedelivery();
        if (connectorRedelivery == -1 || connectorRedelivery < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"We were asked to ignore the redelivery count, nothing to do here.");
            }
            return;
        }
        String id = message.getJMSMessageID();
        if (id == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message doesn't have a JMSMessageID set, Mule can't handle redelivery for it. " + message));
            }
            return;
        }
        Integer redeliveryCount = this.messages.remove(id);
        if (redeliveryCount != null) {
            redeliveryCount = redeliveryCount + 1;
        }
        if (redeliveryCount == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the first time"));
            }
            this.messages.put(id, 1);
        } else if (redeliveryCount == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered for the first time"));
            }
            if (connectorRedelivery == 0) {
                MuleMessage msg = this.createMuleMessage(message);
                throw new MessageRedeliveredException(id, redeliveryCount, connectorRedelivery, endpoint, flow, msg);
            }
        } else {
            if (redeliveryCount > connectorRedelivery) {
                MuleMessage msg = this.createMuleMessage(message);
                throw new MessageRedeliveredException(id, redeliveryCount, connectorRedelivery, endpoint, flow, msg);
            }
            this.messages.put(id, redeliveryCount);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + id + " has been redelivered " + redeliveryCount + " times"));
            }
        }
    }
}

