/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.workgroup.packet.TranscriptSearch;

public class TranscriptSearchManager {
    private XMPPConnection connection;

    public TranscriptSearchManager(XMPPConnection connection) {
        this.connection = connection;
    }

    public Form getSearchForm(String serviceJID) throws XMPPException {
        TranscriptSearch search = new TranscriptSearch();
        search.setType(IQ.Type.GET);
        search.setTo(serviceJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        this.connection.sendPacket((Packet)search);
        TranscriptSearch response = (TranscriptSearch)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return Form.getFormFrom((Packet)response);
    }

    public ReportedData submitSearch(String serviceJID, Form completedForm) throws XMPPException {
        TranscriptSearch search = new TranscriptSearch();
        search.setType(IQ.Type.GET);
        search.setTo(serviceJID);
        search.addExtension(completedForm.getDataFormToSend());
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        this.connection.sendPacket((Packet)search);
        TranscriptSearch response = (TranscriptSearch)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return ReportedData.getReportedDataFrom((Packet)response);
    }
}

