/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.jobs;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.module.client.MuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.ScheduledDispatchJobConfig;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;

public class ScheduledDispatchJob
implements Job,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        ScheduledDispatchJobConfig config;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Object payload = jobDataMap.get((Object)"payload");
        if (payload == null) {
            payload = NullPayload.getInstance();
        }
        if ((config = (ScheduledDispatchJobConfig)jobDataMap.get((Object)"jobConfig")) == null) {
            throw new JobExecutionException(QuartzMessages.missingJobDetail("jobConfig").getMessage());
        }
        try {
            SchedulerContext schedulerContext = jobExecutionContext.getScheduler().getContext();
            MuleContext muleContext = (MuleContext)schedulerContext.get((Object)"mule.context");
            String endpointRef = config.getEndpointRef();
            if (jobDataMap.containsKey((Object)"endpointRef")) {
                endpointRef = (String)jobDataMap.get((Object)"endpointRef");
            }
            this.logger.debug((Object)("Dispatching payload on: " + config.getEndpointRef()));
            MuleClient client = new MuleClient(muleContext);
            client.dispatch(endpointRef, payload, (Map)jobDataMap);
        }
        catch (MuleException e) {
            throw new JobExecutionException((Throwable)e);
        }
        catch (SchedulerException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }
}

