/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression.transformers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.AbstractExpressionTransformer;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.object.PrototypeObjectFactory;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilderTransformer
extends AbstractExpressionTransformer {
    private ObjectFactory beanFactory;
    private Class<?> beanClass;

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public ObjectFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(ObjectFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.getBeanFactory() == null && this.getBeanClass() == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("beanFactory"), (Initialisable)this);
        }
        if (this.getBeanClass() != null) {
            this.setBeanFactory(new PrototypeObjectFactory(this.getBeanClass()));
        }
        this.setReturnDataType(DataTypeFactory.create(this.getBeanFactory().getObjectClass()));
        if (this.getBeanFactory() instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.getBeanFactory())).setMuleContext(this.muleContext);
        }
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object bean;
        try {
            bean = this.getBeanFactory().getInstance(this.muleContext);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        HashMap<String, Object> args = new HashMap<String, Object>(this.arguments.size());
        for (ExpressionArgument argument : this.arguments) {
            Object value = null;
            try {
                value = argument.evaluate(message);
            }
            catch (RequiredValueException e) {
                this.logger.warn((Object)e.getMessage());
            }
            catch (ExpressionRuntimeException e) {
                throw new TransformerException(this, (Throwable)e);
            }
            if (!argument.isOptional() && value == null) {
                throw new TransformerException(CoreMessages.expressionEvaluatorReturnedNull(argument.getExpressionConfig().getEvaluator(), argument.getExpressionConfig().getExpression()), this);
            }
            args.put(argument.getName(), value);
        }
        try {
            BeanUtils.populate(bean, args);
        }
        catch (IllegalAccessException e) {
            throw new TransformerException(this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new TransformerException(this, e.getTargetException());
        }
        return bean;
    }
}

