/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import org.jbpm.api.JbpmException;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;

public class TransitionStartActivity
extends AtomicOperation {
    private static final long serialVersionUID = 1L;

    public boolean isAsync(ExecutionImpl execution) {
        return false;
    }

    public void perform(ExecutionImpl execution) {
        TransitionImpl transition = execution.getTransition();
        ActivityImpl source = transition.getSource();
        ActivityImpl destination = transition.getDestination();
        ActivityImpl activity = execution.getActivity();
        if (activity == null) {
            activity = destination;
            while (activity.getParentActivity() != null && !activity.getParentActivity().contains(source)) {
                activity = activity.getParentActivity();
            }
        } else if (activity == destination) {
            activity = null;
        } else {
            ActivityImpl parent = activity;
            for (activity = destination; activity != null && activity.getParent() != parent; activity = activity.getParentActivity()) {
            }
            if (activity == null) {
                throw new JbpmException("implementation bug: couldn't find parent " + parent + " around destination " + destination);
            }
        }
        if (activity == null) {
            execution.setTransition(null);
            execution.performAtomicOperation(AtomicOperation.EXECUTE_ACTIVITY);
        } else {
            execution.setActivity(activity);
            ExecutionImpl propagatingExecution = execution;
            if (activity.isLocalScope()) {
                propagatingExecution = execution.createScope(activity);
            }
            propagatingExecution.fire("start", activity, AtomicOperation.TRANSITION_START_ACTIVITY);
        }
    }

    public MessageImpl createAsyncMessage(ExecutionImpl execution) {
        throw new UnsupportedOperationException("please implement me");
    }

    public String toString() {
        return "TransitionStartActivity";
    }
}

