/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.mule.ResponseOutputStream;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.transport.tcp.protocols.LengthProtocol;
import org.mule.transport.tcp.protocols.ProtocolStream;

public class SafeProtocol
implements TcpProtocol {
    public static final String COOKIE = "You are using SafeProtocol";
    private TcpProtocol delegate = new LengthProtocol();
    private TcpProtocol cookieProtocol = new LengthProtocol("You are using SafeProtocol".length());

    public Object read(InputStream is) throws IOException {
        if (this.assertSiblingSafe(is)) {
            Object result = this.delegate.read(is);
            if (null == result) {
                this.helpUser();
            }
            return result;
        }
        return null;
    }

    public void write(OutputStream os, Object data) throws IOException {
        this.assureSibling(os);
        this.delegate.write(os, data);
    }

    public ResponseOutputStream createResponse(Socket socket) throws IOException {
        return new ResponseOutputStream(socket, (OutputStream)new ProtocolStream(this, false, socket.getOutputStream()));
    }

    private void assureSibling(OutputStream os) throws IOException {
        this.cookieProtocol.write(os, COOKIE);
    }

    private boolean assertSiblingSafe(InputStream is) throws IOException {
        Object cookie = null;
        try {
            cookie = this.cookieProtocol.read(is);
        }
        catch (Exception e) {
            this.helpUser(e);
        }
        if (null != cookie) {
            if (!(cookie instanceof byte[]) || ((byte[])cookie).length != COOKIE.length() || !COOKIE.equals(new String((byte[])cookie))) {
                this.helpUser();
            } else {
                return true;
            }
        }
        return false;
    }

    private void helpUser() throws IOException {
        throw new IOException("You are not using a consistent protocol on your TCP transport. Please read the documentation for the TCP transport, paying particular attention to the protocol parameter.");
    }

    private void helpUser(Exception e) throws IOException {
        throw (IOException)new IOException("An error occurred while verifying your connection.  You may not be using a consistent protocol on your TCP transport. Please read the documentation for the TCP transport, paying particular attention to the protocol parameter.").initCause(e);
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.delegate = new LengthProtocol(maxMessageLength);
    }
}

