/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.UrlEndpointURIBuilder;
import org.mule.endpoint.UserInfoEndpointURIBuilder;
import org.mule.tck.AbstractMuleTestCase;

public class EndpointURIBuilderTestCase
extends AbstractMuleTestCase {
    private static final String PLAIN_USERNAME_URI = "test://user:secret@theHost:42/path?key=value#fragment";
    private static final String EXPECTED_PLAIN_URI_STRING = "test://user:****@theHost:42/path?key=value#fragment";
    private static final String USERNAME_WITH_AT_SIGN_URI = "test://user%40host:secret@theHost:42/path?key=value#fragment";
    private static final String EXPECTED_AT_SIGN_URI_STRING = "test://user%40host:****@theHost:42/path?key=value#fragment";

    public void testGetPropertiesForURI() throws MalformedEndpointException, URISyntaxException {
        UrlEndpointURIBuilder endpointURIBuilder = new UrlEndpointURIBuilder();
        endpointURIBuilder.build(new URI("ftp://test%25user:test@192.168.1.12:21"), muleContext);
        EndpointURIBuilderTestCase.assertEquals((String)"test%user:test", (String)endpointURIBuilder.userInfo);
    }

    public void testUrlEndpointBuilderPasswordMasking() throws Exception {
        UrlEndpointURIBuilder builder = new UrlEndpointURIBuilder();
        this.checkUriWithPlainUsername((EndpointURIBuilder)builder);
    }

    public void testUrlEndpointBuilderPasswordMaskingWithAtSign() throws Exception {
        UrlEndpointURIBuilder builder = new UrlEndpointURIBuilder();
        this.checkUriWithUsernameContainingAtSign((EndpointURIBuilder)builder);
    }

    public void testUserInfoEndpointBuilderPasswordMasking() throws Exception {
        UserInfoEndpointURIBuilder builder = new UserInfoEndpointURIBuilder();
        this.checkUriWithPlainUsername((EndpointURIBuilder)builder);
    }

    public void testUserInfoEndpointBuilderPasswordMaskingWithAtSign() throws Exception {
        UserInfoEndpointURIBuilder builder = new UserInfoEndpointURIBuilder();
        this.checkUriWithUsernameContainingAtSign((EndpointURIBuilder)builder);
    }

    private void checkUriWithPlainUsername(EndpointURIBuilder builder) throws Exception {
        URI inputUri = new URI(PLAIN_USERNAME_URI);
        EndpointURI uri = builder.build(inputUri, muleContext);
        EndpointURIBuilderTestCase.assertEquals((String)"user", (String)uri.getUser());
        this.assertUriParts(uri);
        EndpointURIBuilderTestCase.assertEquals((String)EXPECTED_PLAIN_URI_STRING, (String)uri.toString());
    }

    private void checkUriWithUsernameContainingAtSign(EndpointURIBuilder builder) throws Exception {
        URI inputUri = new URI(USERNAME_WITH_AT_SIGN_URI);
        EndpointURI uri = builder.build(inputUri, muleContext);
        EndpointURIBuilderTestCase.assertEquals((String)"user@host", (String)uri.getUser());
        this.assertUriParts(uri);
        EndpointURIBuilderTestCase.assertEquals((String)EXPECTED_AT_SIGN_URI_STRING, (String)uri.toString());
    }

    private void assertUriParts(EndpointURI uri) {
        EndpointURIBuilderTestCase.assertEquals((String)"secret", (String)uri.getPassword());
        EndpointURIBuilderTestCase.assertEquals((String)"theHost", (String)uri.getHost());
        EndpointURIBuilderTestCase.assertEquals((int)42, (int)uri.getPort());
        EndpointURIBuilderTestCase.assertEquals((String)"/path", (String)uri.getPath());
        EndpointURIBuilderTestCase.assertEquals((String)"key=value", (String)uri.getQuery());
    }
}

