/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.HashMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.api.security.SecurityFilter;
import org.mule.api.transformer.Transformer;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.NullMessageProcessor;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.transformer.simple.InboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;

public class InboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    private static final String TEST_MESSAGE = "test";
    private InboundEndpoint endpoint;
    private SensingNullMessageProcessor inboundListener;
    private MuleMessage inMessage;
    private MuleEvent requestEvent;
    private MuleEvent responseEvent;
    private MuleEvent result;
    private static String RESPONSE_MESSAGE = "response-message";

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.inMessage = this.createTestRequestMessage();
        this.inboundListener = new SensingNullMessageProcessor();
    }

    public void testDefaultFlowSync() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        InboundEndpointTestCase.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    public void testDefaultFlowAsync() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(false);
        InboundEndpointTestCase.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    public void testFilterAccept() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(new AbstractMessageProcessorTestCase.TestFilter(true), null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        InboundEndpointTestCase.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    public void testFilterNotAccept() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(new AbstractMessageProcessorTestCase.TestFilter(false), null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        InboundEndpointTestCase.assertNotNull((Object)this.result);
        InboundEndpointTestCase.assertNotNull((String)"Filter should have thrown a FilterException", (Object)this.result.getMessage().getExceptionPayload());
        InboundEndpointTestCase.assertTrue((boolean)(this.result.getMessage().getExceptionPayload().getException() instanceof FilterUnacceptedException));
        this.assertMessageNotSent();
    }

    public void testSecurityFilterAccept() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        InboundEndpointTestCase.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
    }

    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        this.endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        RequestContext.setEvent((MuleEvent)this.requestEvent);
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageNotSent();
        InboundEndpointTestCase.assertNotNull((Object)this.result);
        InboundEndpointTestCase.assertEquals((String)"unauthorized!!", (String)this.result.getMessage().getPayloadAsString());
        InboundEndpointTestCase.assertNotNull((Object)this.result.getMessage().getExceptionPayload());
        InboundEndpointTestCase.assertTrue((boolean)(this.result.getMessage().getExceptionPayload().getException() instanceof TestSecurityFilter.StaticMessageUnauthorisedException));
        InboundEndpointTestCase.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        InboundEndpointTestCase.assertEquals((int)401, (int)securityNotificationListener.securityNotification.getAction());
        InboundEndpointTestCase.assertEquals((String)securityNotificationListener.securityNotification.getResourceIdentifier(), (String)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    public void testFilterFirstThenSecurityFilter() throws Exception {
        TestSecurityFilter securityFilter = new TestSecurityFilter(false);
        this.endpoint = this.createTestInboundEndpoint(new AbstractMessageProcessorTestCase.TestFilter(false), (SecurityFilter)securityFilter, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        InboundEndpointTestCase.assertNotNull((Object)this.result);
        InboundEndpointTestCase.assertNotNull((String)"Filter should have thrown a FilterException", (Object)this.result.getMessage().getExceptionPayload());
        InboundEndpointTestCase.assertTrue((boolean)(this.result.getMessage().getExceptionPayload().getException() instanceof FilterUnacceptedException));
        InboundEndpointTestCase.assertFalse((boolean)securityFilter.wasCalled());
        this.assertMessageNotSent();
    }

    public void testMessagePropertyErrorMapping() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent.getMessage().setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSentSame(true);
        InboundEndpointTestCase.assertEquals((Object)this.responseEvent.getMessage(), (Object)this.result.getMessage());
        int status = (Integer)this.result.getMessage().getOutboundProperty("status", (Object)0);
        InboundEndpointTestCase.assertEquals((int)500, (int)status);
    }

    public void testResponseTransformerExceptionDetailAfterRequestFlowInterupt() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)new TestSecurityFilter(false), null, (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent.getMessage().setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        RequestContext.setEvent((MuleEvent)this.requestEvent);
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageNotSent();
        InboundEndpointTestCase.assertNotNull((Object)this.result);
        InboundEndpointTestCase.assertEquals((String)("unauthorized!!" + ResponseAppendTransformer.APPEND_STRING), (String)this.result.getMessage().getPayloadAsString());
        int status = (Integer)this.result.getMessage().getOutboundProperty("status", (Object)0);
        InboundEndpointTestCase.assertEquals((int)403, (int)status);
        InboundEndpointTestCase.assertNotNull((Object)this.result.getMessage().getExceptionPayload());
        InboundEndpointTestCase.assertTrue((boolean)(this.result.getMessage().getExceptionPayload().getException() instanceof TestSecurityFilter.StaticMessageUnauthorisedException));
    }

    public void testNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        this.endpoint = this.createTestInboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        InboundEndpointTestCase.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        InboundEndpointTestCase.assertEquals((int)801, (int)listener.messageNotification.getAction());
        InboundEndpointTestCase.assertEquals((String)this.endpoint.getEndpointURI().getUri().toString(), (String)listener.messageNotification.getEndpoint());
        InboundEndpointTestCase.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        InboundEndpointTestCase.assertEquals((Object)this.inMessage.getPayload(), (Object)listener.messageNotification.getSource().getPayload());
    }

    public void testTransformers() throws Exception {
        this.endpoint = this.createTestInboundEndpoint(null, null, (Transformer)new InboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        this.endpoint.setListener((MessageProcessor)this.inboundListener);
        this.requestEvent = this.createTestRequestEvent((ImmutableEndpoint)this.endpoint);
        this.responseEvent = this.createTestResponseEvent((ImmutableEndpoint)this.endpoint);
        MessageProcessor mpChain = ((AbstractEndpoint)this.endpoint).getMessageProcessorChain(this.requestEvent.getFlowConstruct());
        this.result = mpChain.process(this.requestEvent);
        this.assertMessageSent(true);
        InboundEndpointTestCase.assertEquals((String)(TEST_MESSAGE + InboundAppendTransformer.APPEND_STRING), (String)this.inboundListener.sensedEvent.getMessageAsString());
        InboundEndpointTestCase.assertNotNull((Object)this.result);
        InboundEndpointTestCase.assertEquals((String)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (String)this.result.getMessage().getPayloadAsString());
    }

    public void testObjectAwareInjection() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://myTestUri", muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new AbstractMessageProcessorTestCase.ObjectAwareProcessor());
        this.endpoint = endpointBuilder.buildInboundEndpoint();
        this.endpoint.setListener((MessageProcessor)new NullMessageProcessor());
        this.endpoint.setFlowConstruct((FlowConstruct)InboundEndpointTestCase.getTestService());
        this.endpoint.start();
        AbstractMessageProcessorTestCase.ObjectAwareProcessor objectAware = (AbstractMessageProcessorTestCase.ObjectAwareProcessor)this.endpoint.getMessageProcessors().get(0);
        InboundEndpointTestCase.assertEquals((Object)muleContext, (Object)objectAware.context);
        InboundEndpointTestCase.assertEquals((Object)this.endpoint, (Object)objectAware.endpoint);
        this.endpoint.stop();
    }

    protected MuleMessage createTestRequestMessage() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("prop1", "value1");
        return new DefaultMuleMessage((Object)TEST_MESSAGE, props, muleContext);
    }

    protected MuleEvent createTestRequestEvent(ImmutableEndpoint endpoint) throws Exception {
        return new DefaultMuleEvent(this.inMessage, endpoint, InboundEndpointTestCase.getTestSession(InboundEndpointTestCase.getTestService(), muleContext));
    }

    protected MuleEvent createTestResponseEvent(ImmutableEndpoint endpoint) throws Exception {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)RESPONSE_MESSAGE, muleContext), endpoint, InboundEndpointTestCase.getTestSession(InboundEndpointTestCase.getTestService(), muleContext));
    }

    protected MuleEvent assertMessageSent(boolean sync) throws MuleException {
        MuleEvent event = this.inboundListener.sensedEvent;
        InboundEndpointTestCase.assertNotNull((Object)event);
        InboundEndpointTestCase.assertEquals((boolean)sync, (boolean)event.getEndpoint().getExchangePattern().hasResponse());
        InboundEndpointTestCase.assertNotNull((Object)event.getMessage());
        return event;
    }

    protected MuleEvent assertMessageSentSame(boolean sync) throws MuleException {
        this.assertMessageSent(sync);
        MuleEvent event = this.inboundListener.sensedEvent;
        InboundEndpointTestCase.assertEquals((Object)this.inMessage, (Object)event.getMessage());
        InboundEndpointTestCase.assertEquals((String)TEST_MESSAGE, (String)event.getMessageAsString());
        InboundEndpointTestCase.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
        return event;
    }

    protected void assertMessageNotSent() throws MuleException {
        MuleEvent event = this.inboundListener.sensedEvent;
        InboundEndpointTestCase.assertNull((Object)event);
    }

    class SensingNullMessageProcessor
    implements MessageProcessor {
        MuleEvent sensedEvent;

        SensingNullMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.sensedEvent = event;
            return InboundEndpointTestCase.this.responseEvent;
        }
    }
}

