/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.QueueProfile;
import org.mule.management.stats.QueueStatistics;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.AsyncWorkListener;
import org.mule.processor.OptionalAsyncInterceptingMessageProcessorTestCase;
import org.mule.processor.SedaStageInterceptingMessageProcessor;

public class SedaStageInterceptingMessageProcessorTestCase
extends OptionalAsyncInterceptingMessageProcessorTestCase
implements ExceptionListener {
    QueueProfile queueProfile = new QueueProfile();
    int queueTimeout;
    QueueStatistics queueStatistics;
    TestLifeCycleState lifeCycleState;

    protected void doSetUp() throws Exception {
        this.queueStatistics = new TestQueueStatistics();
        this.queueTimeout = muleContext.getConfiguration().getDefaultQueueTimeout();
        this.lifeCycleState = new TestLifeCycleState();
        super.doSetUp();
        ((Initialisable)this.messageProcessor).initialise();
        ((Startable)this.messageProcessor).start();
        this.lifeCycleState.start();
    }

    protected boolean isStartContext() {
        return false;
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        ((Stoppable)this.messageProcessor).stop();
        this.lifeCycleState.stop();
        this.lifeCycleState.dispose();
    }

    protected AsyncInterceptingMessageProcessor createAsyncInterceptingMessageProcessor(MessageProcessor listener) throws Exception {
        SedaStageInterceptingMessageProcessor mp = new SedaStageInterceptingMessageProcessor("name", this.queueProfile, this.queueTimeout, muleContext.getDefaultThreadingProfile(), this.queueStatistics, muleContext);
        mp.setListener(listener);
        return mp;
    }

    public void testSpiWorkThrowableHandling() throws Exception {
        try {
            new AsyncWorkListener((MessageProcessor)this.getSensingNullMessageProcessor()).handleWorkException(this.getTestWorkEvent(), "workRejected");
        }
        catch (MuleRuntimeException mrex) {
            SedaStageInterceptingMessageProcessorTestCase.assertNotNull((Object)((Object)mrex));
            SedaStageInterceptingMessageProcessorTestCase.assertTrue((mrex.getCause().getClass() == Throwable.class ? 1 : 0) != 0);
            SedaStageInterceptingMessageProcessorTestCase.assertEquals((String)"testThrowable", (String)mrex.getCause().getMessage());
        }
    }

    private WorkEvent getTestWorkEvent() {
        return new WorkEvent((Object)this, 2, this.getTestWork(), new WorkException(new Throwable("testThrowable")));
    }

    private Work getTestWork() {
        return new Work(){

            public void release() {
            }

            public void run() {
            }
        };
    }

    class TestLifeCycleState
    implements LifecycleState,
    Lifecycle {
        AtomicBoolean started = new AtomicBoolean(false);
        AtomicBoolean stopped = new AtomicBoolean(true);
        AtomicBoolean disposed = new AtomicBoolean(false);
        AtomicBoolean initialised = new AtomicBoolean(false);
        AtomicBoolean paused = new AtomicBoolean(false);

        TestLifeCycleState() {
        }

        public boolean isDisposed() {
            return this.disposed.get();
        }

        public boolean isDisposing() {
            return false;
        }

        public boolean isInitialised() {
            return this.initialised.get();
        }

        public boolean isInitialising() {
            return false;
        }

        public boolean isPhaseComplete(String phase) {
            if ("pause".equals(phase)) {
                return this.paused.get();
            }
            return false;
        }

        public boolean isPhaseExecuting(String phase) {
            return false;
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public boolean isStarting() {
            return false;
        }

        public boolean isStopped() {
            return this.stopped.get();
        }

        public boolean isStopping() {
            return false;
        }

        public void initialise() throws InitialisationException {
            this.initialised.set(true);
        }

        public void start() throws MuleException {
            this.initialised.set(false);
            this.stopped.set(false);
            this.started.set(true);
        }

        public void stop() throws MuleException {
            this.started.set(false);
            this.stopped.set(true);
        }

        public void dispose() {
            this.stopped.set(true);
            this.disposed.set(true);
        }

        public boolean isValidTransition(String phase) {
            return false;
        }
    }

    class TestQueueStatistics
    implements QueueStatistics {
        int incCount;
        int decCount;

        TestQueueStatistics() {
        }

        public void decQueuedEvent() {
            ++this.decCount;
        }

        public void incQueuedEvent() {
            ++this.incCount;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

