/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.routing.CollectionSplitter;
import org.mule.tck.AbstractMuleTestCase;

public class CollectionMessageSplitterTestCase
extends AbstractMuleTestCase {
    public CollectionMessageSplitterTestCase() {
        this.setStartContext(true);
    }

    public void testRouter() throws Exception {
        Service fc = CollectionMessageSplitterTestCase.getTestService();
        MuleSession session = CollectionMessageSplitterTestCase.getTestSession(fc, muleContext);
        HashMap<String, Object> inboundProps = new HashMap<String, Object>();
        inboundProps.put("inbound1", "1");
        inboundProps.put("inbound2", 2);
        inboundProps.put("inbound3", session);
        HashMap outboundProps = new HashMap();
        inboundProps.put("outbound1", "3");
        inboundProps.put("outbound2", 4);
        inboundProps.put("outbound3", session);
        HashMap invocationProps = new HashMap();
        inboundProps.put("invoke1", "5");
        inboundProps.put("invoke2", 6);
        inboundProps.put("invoke3", session);
        List<String> payload = Arrays.asList("abc", "def", "ghi");
        DefaultMuleMessage toSplit = new DefaultMuleMessage(payload, inboundProps, outboundProps, null, muleContext);
        for (Map.Entry entry : invocationProps.entrySet()) {
            toSplit.setInvocationProperty((String)entry.getKey(), entry.getValue());
        }
        CollectionSplitter splitter = new CollectionSplitter();
        splitter.setMuleContext(muleContext);
        Grabber grabber = new Grabber();
        splitter.setListener((MessageProcessor)grabber);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)toSplit, (ImmutableEndpoint)CollectionMessageSplitterTestCase.getTestOutboundEndpoint("ep"), session);
        splitter.process((MuleEvent)event);
        List<MuleMessage> splits = grabber.getMessages();
        CollectionMessageSplitterTestCase.assertEquals((int)3, (int)splits.size());
        for (MuleMessage msg : splits) {
            CollectionMessageSplitterTestCase.assertTrue((boolean)(msg.getPayload() instanceof String));
            String str = (String)msg.getPayload();
            CollectionMessageSplitterTestCase.assertTrue((boolean)payload.contains(str));
            for (String key : inboundProps.keySet()) {
                CollectionMessageSplitterTestCase.assertEquals((Object)msg.getInboundProperty(key), inboundProps.get(key));
            }
            for (String key : outboundProps.keySet()) {
                CollectionMessageSplitterTestCase.assertEquals((Object)msg.getOutboundProperty(key), outboundProps.get(key));
            }
            for (String key : invocationProps.keySet()) {
                CollectionMessageSplitterTestCase.assertEquals((Object)msg.getInvocationProperty(key), invocationProps.get(key));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Grabber
    implements MessageProcessor {
        private List<MuleMessage> messages = new ArrayList<MuleMessage>();

        Grabber() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.messages.add(event.getMessage());
            return null;
        }

        public List<MuleMessage> getMessages() {
            return this.messages;
        }
    }
}

