/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.simple.ByteArrayToMuleMessage;
import org.mule.transformer.simple.MuleMessageToByteArray;

public class SerializedMuleMessageTransformersTestCase
extends AbstractTransformerTestCase {
    private MuleMessage testObject = null;

    protected void doSetUp() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("object", new Apple());
        props.put("number", 1);
        props.put("string", "hello");
        this.testObject = new DefaultMuleMessage((Object)"test", props, muleContext);
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent(this.testObject, (ImmutableEndpoint)SerializedMuleMessageTransformersTestCase.getTestOutboundEndpoint("test"), MuleTestUtils.getTestSession(muleContext)));
    }

    protected void doTearDown() throws Exception {
        RequestContext.clear();
    }

    public void testTransform() throws Exception {
    }

    public Transformer getTransformer() throws Exception {
        return (Transformer)this.createObject(MuleMessageToByteArray.class);
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return (Transformer)this.createObject(ByteArrayToMuleMessage.class);
    }

    public Object getTestData() {
        return this.testObject;
    }

    public Object getResultData() {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)bs);
            os.writeObject(this.testObject);
            os.flush();
            os.close();
            return bs.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public boolean compareResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        return Arrays.equals((byte[])src, (byte[])result);
    }

    public boolean compareRoundtripResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        if (src instanceof MuleMessage && result instanceof MuleMessage) {
            MuleMessage sourceMuleMessage = (MuleMessage)src;
            MuleMessage resultMuleMessage = (MuleMessage)result;
            boolean payloadsAreEqual = this.comparePayloads(sourceMuleMessage, resultMuleMessage);
            boolean objectPropertiesAreEqual = this.compareObjectProperties(sourceMuleMessage, resultMuleMessage);
            boolean stringPropertiesAreEqual = this.compareStringProperties(sourceMuleMessage, resultMuleMessage);
            boolean intPropertiesAreEqual = this.compareIntProperties(sourceMuleMessage, resultMuleMessage);
            return payloadsAreEqual && objectPropertiesAreEqual && stringPropertiesAreEqual && intPropertiesAreEqual;
        }
        return false;
    }

    private boolean comparePayloads(MuleMessage src, MuleMessage result) {
        Object sourcePayload = src.getPayload();
        Object resultPayload = result.getPayload();
        return sourcePayload.equals(resultPayload);
    }

    private boolean compareObjectProperties(MuleMessage src, MuleMessage result) {
        Object sourceObjectProperty = src.getOutboundProperty("object");
        Object resultObjectProperty = result.getOutboundProperty("object");
        return sourceObjectProperty.equals(resultObjectProperty);
    }

    private boolean compareStringProperties(MuleMessage src, MuleMessage result) {
        Object sourceStringProperty = src.getOutboundProperty("string");
        Object resultStringProperty = result.getOutboundProperty("string");
        return sourceStringProperty.equals(resultStringProperty);
    }

    private boolean compareIntProperties(MuleMessage src, MuleMessage result) {
        int resultIntProperty;
        int sourceIntProperty = (Integer)src.getOutboundProperty("number", (Object)-1);
        return sourceIntProperty == (resultIntProperty = ((Integer)result.getOutboundProperty("number", (Object)-2)).intValue());
    }
}

