/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.redelivery;

import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.redelivery.AbstractRedeliveryHandler;
import org.mule.transport.jms.redelivery.CountingRedeliveryHandler;
import org.mule.transport.jms.redelivery.JmsXRedeliveryHandler;
import org.mule.transport.jms.redelivery.RedeliveryHandler;
import org.mule.transport.jms.redelivery.RedeliveryHandlerFactory;

public class AutoDiscoveryRedeliveryHandlerFactory
implements RedeliveryHandlerFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected AtomicReference<RedeliveryHandler> delegateHandler = new AtomicReference<Object>(null);
    protected JmsConnector connector;

    public AutoDiscoveryRedeliveryHandlerFactory(JmsConnector connector) {
        if (connector == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"connector").getMessage());
        }
        this.connector = connector;
    }

    public RedeliveryHandler create() {
        RedeliveryHandler newInstance;
        boolean ok;
        RedeliveryHandler result = this.delegateHandler.get() == null ? (!(ok = this.delegateHandler.compareAndSet(null, newInstance = this.createInstance())) ? this.delegateHandler.get() : newInstance) : this.delegateHandler.get();
        return result;
    }

    protected RedeliveryHandler createInstance() {
        AbstractRedeliveryHandler newInstance;
        try {
            ConnectionMetaData metaData = this.connector.getConnection().getMetaData();
            boolean supportsDeliveryCount = false;
            Enumeration propNames = metaData.getJMSXPropertyNames();
            while (propNames.hasMoreElements()) {
                String p = (String)propNames.nextElement();
                if (!"JMSXDeliveryCount".equals(p)) continue;
                supportsDeliveryCount = true;
                break;
            }
            newInstance = supportsDeliveryCount ? new JmsXRedeliveryHandler() : new CountingRedeliveryHandler();
        }
        catch (JMSException e) {
            newInstance = new CountingRedeliveryHandler();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using " + newInstance.getClass().getName()));
        }
        return newInstance;
    }
}

