/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.transformers;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTransformer
extends AbstractMessageTransformer {
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            String v = message.getPayloadAsString();
            HashMap<String, Object> values = new HashMap<String, Object>();
            StringTokenizer tokenizer = new StringTokenizer(v, "&");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int idx = token.indexOf(61);
                if (idx < 0) {
                    this.add(values, URLDecoder.decode(token, outputEncoding), null);
                    continue;
                }
                if (idx <= 0) continue;
                this.add(values, URLDecoder.decode(token.substring(0, idx), outputEncoding), URLDecoder.decode(token.substring(idx + 1), outputEncoding));
            }
            return values;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    private void add(Map<String, Object> values, String key, String value) {
        Object existingValue = values.get(key);
        if (existingValue == null) {
            values.put(key, value);
        } else if (existingValue instanceof List) {
            List list = (List)existingValue;
            list.add(value);
        } else if (existingValue instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)existingValue);
            list.add(value);
            values.put(key, list);
        }
    }
}

