/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.util.Iterator;
import java.util.List;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocationDefinition;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceMapping;

public class FilterInvocationDefinitionDecorator
implements FilterInvocationDefinition {
    private FilterInvocationDefinition decorated;
    private List mappings;

    public FilterInvocationDefinitionDecorator() {
    }

    public FilterInvocationDefinitionDecorator(FilterInvocationDefinition decorated) {
        this.setDecorated(decorated);
    }

    public void setDecorated(FilterInvocationDefinition decorated) {
        this.decorated = decorated;
    }

    public FilterInvocationDefinition getDecorated() {
        return this.decorated;
    }

    public void setMappings(List mappings) {
        if (this.decorated == null) {
            throw new IllegalStateException("decorated object has not been set");
        }
        this.mappings = mappings;
        Iterator it = mappings.iterator();
        while (it.hasNext()) {
            FilterInvocationDefinitionSourceMapping mapping = (FilterInvocationDefinitionSourceMapping)it.next();
            ConfigAttributeDefinition configDefinition = new ConfigAttributeDefinition();
            Iterator configAttributesIt = mapping.getConfigAttributes().iterator();
            while (configAttributesIt.hasNext()) {
                String s = (String)configAttributesIt.next();
                configDefinition.addConfigAttribute(new SecurityConfig(s));
            }
            this.decorated.addSecureUrl(mapping.getUrl(), configDefinition);
        }
    }

    public List getMappings() {
        return this.mappings;
    }

    public void addSecureUrl(String expression, ConfigAttributeDefinition attr) {
        this.getDecorated().addSecureUrl(expression, attr);
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.getDecorated().isConvertUrlToLowercaseBeforeComparison();
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.getDecorated().setConvertUrlToLowercaseBeforeComparison(convertUrlToLowercaseBeforeComparison);
    }

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        return this.getDecorated().getAttributes(object);
    }

    public Iterator getConfigAttributeDefinitions() {
        return this.getDecorated().getConfigAttributeDefinitions();
    }

    public boolean supports(Class clazz) {
        return this.getDecorated().supports(clazz);
    }
}

