/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.processor.chain.DefaultMessageProcessorChain;

public class MessageProcessors {
    private MessageProcessors() {
    }

    public static MessageProcessorChain singletonChain(MessageProcessor mp) {
        return DefaultMessageProcessorChain.from(mp);
    }

    public static MessageProcessor lifecyleAwareMessageProcessorWrapper(MessageProcessor mp) {
        return new LifecyleAwareMessageProcessorWrapper(mp);
    }

    private static class LifecyleAwareMessageProcessorWrapper
    implements MessageProcessor,
    Lifecycle,
    MuleContextAware,
    FlowConstructAware {
        private MessageProcessor delegate;

        public LifecyleAwareMessageProcessorWrapper(MessageProcessor delegate) {
            this.delegate = delegate;
        }

        public void initialise() throws InitialisationException {
            if (this.delegate instanceof Initialisable) {
                ((Initialisable)((Object)this.delegate)).initialise();
            }
        }

        public void start() throws MuleException {
            if (this.delegate instanceof Startable) {
                ((Startable)((Object)this.delegate)).start();
            }
        }

        public void stop() throws MuleException {
            if (this.delegate instanceof Stoppable) {
                ((Stoppable)((Object)this.delegate)).stop();
            }
        }

        public void dispose() {
            if (this.delegate instanceof Disposable) {
                ((Disposable)((Object)this.delegate)).dispose();
            }
        }

        public void setFlowConstruct(FlowConstruct flowConstruct) {
            if (this.delegate instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)this.delegate)).setFlowConstruct(flowConstruct);
            }
        }

        public void setMuleContext(MuleContext context) {
            if (this.delegate instanceof MuleContextAware) {
                ((MuleContextAware)((Object)this.delegate)).setMuleContext(context);
            }
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return this.delegate.process(event);
        }
    }
}

