/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.AbstractSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionSplitter
extends AbstractSplitter
implements Initialisable {
    protected ExpressionManager expressionManager;
    protected ExpressionConfig config = new ExpressionConfig();

    public ExpressionSplitter() {
    }

    public ExpressionSplitter(ExpressionConfig config) {
        this.config = config;
        this.setEvaluator(config.getEvaluator());
    }

    @Override
    public void initialise() throws InitialisationException {
        this.expressionManager = this.muleContext.getExpressionManager();
        this.config.validate(this.expressionManager);
    }

    @Override
    protected List<MuleMessage> splitMessage(MuleEvent event) {
        Object result = event.getMuleContext().getExpressionManager().evaluate(this.config.getFullExpression(this.expressionManager), event.getMessage());
        if (result instanceof List) {
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
            for (Object object : (List)result) {
                messages.add(new DefaultMuleMessage(object, this.muleContext));
            }
            return messages;
        }
        if (result instanceof MuleMessage) {
            return Collections.singletonList((MuleMessage)result);
        }
        return Collections.singletonList(new DefaultMuleMessage(result, this.muleContext));
    }

    public String getCustomEvaluator() {
        return this.config.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.config.setCustomEvaluator(customEvaluator);
    }

    public String getEvaluator() {
        return this.config.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        if (evaluator.equals("xpath")) {
            evaluator = "xpath-node";
        }
        this.config.setEvaluator(evaluator);
    }

    public String getExpression() {
        return this.config.getExpression();
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }
}

