/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.util.UUID;
import org.mule.util.queue.QueuePersistenceStrategy;

public class MemoryPersistenceStrategy
implements QueuePersistenceStrategy {
    private Map map = Collections.synchronizedMap(new HashMap());

    protected Object getId(Object obj) {
        return UUID.getUUID();
    }

    public Object store(String queue, Object obj) throws IOException {
        if (obj == null) {
            throw new IllegalArgumentException("Cannot store null object.");
        }
        Object id = this.getId(obj);
        this.map.put(id, obj);
        return id;
    }

    public Object load(String queue, Object id) throws IOException {
        return this.map.get(id);
    }

    public void remove(String queue, Object id) throws IOException {
        this.map.remove(id);
    }

    public List restore() throws IOException {
        return new ArrayList();
    }

    public void open() throws IOException {
    }

    public void close() throws IOException {
    }

    public boolean isTransient() {
        return true;
    }
}

