/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.config;

import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.NamedObject;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.transport.quartz.QuartzConnector;
import org.quartz.Scheduler;

public class ScheduleConfigBuilder
implements NamedObject {
    private EndpointBuilder endpointBuilder;
    private QuartzConnector connector;
    private String scheduleId;

    public ScheduleConfigBuilder(String scheduleId, MuleContext muleContext) throws MuleException {
        this.scheduleId = scheduleId;
        this.endpointBuilder = muleContext.getEndpointFactory().getEndpointBuilder("quartz://" + scheduleId);
        this.endpointBuilder.setMuleContext(muleContext);
        this.endpointBuilder.setName(scheduleId);
        this.connector = new QuartzConnector(muleContext);
        this.connector.setName(scheduleId);
        this.endpointBuilder.setConnector((Connector)this.connector);
        this.endpointBuilder.setExchangePattern(MessageExchangePattern.ONE_WAY);
    }

    public ScheduleConfigBuilder addSchedulerFactoryProperty(String key, String value) {
        this.connector.getFactoryProperties().put(key, value);
        return this;
    }

    public ScheduleConfigBuilder setScheduler(Scheduler scheduler) {
        this.connector.setQuartzScheduler(scheduler);
        return this;
    }

    public ScheduleConfigBuilder setCron(String cron) {
        this.endpointBuilder.setProperty((Object)"cronExpression", (Object)cron);
        return this;
    }

    public ScheduleConfigBuilder setInterval(long interval) {
        this.endpointBuilder.setProperty((Object)"repeatInterval", (Object)interval);
        return this;
    }

    public ScheduleConfigBuilder setStartDelay(long delay) {
        this.endpointBuilder.setProperty((Object)"startDelay", (Object)delay);
        return this;
    }

    public InboundEndpoint buildScheduler() throws MuleException {
        return this.endpointBuilder.buildInboundEndpoint();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    public String getName() {
        return this.scheduleId + ".builder";
    }
}

