/*
 * $Id: ExceptionListener.java 21886 2011-05-11 22:45:18Z pablo.kraan $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.sftp.notification;

import org.mule.api.exception.SystemExceptionHandler;
import org.mule.routing.filters.WildcardFilter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionListener implements SystemExceptionHandler
{
    private static final Logger logger = LoggerFactory.getLogger(ExceptionListener.class);

    public void handleException(Exception e)
    {
        logger.debug(e.getLocalizedMessage());
    }

    public WildcardFilter getCommitTxFilter()
    {
        return null;
    }

    public WildcardFilter getRollbackTxFilter()
    {
        return null;
    }

}
