/*
 * $Id: NumberUtilsTestCase.java 20321 2010-11-24 15:21:24Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.util;

import org.mule.tck.AbstractMuleTestCase;

import java.util.Calendar;

public class NumberUtilsTestCase extends AbstractMuleTestCase
{
    static final long l = 1000000000;

    public void testStringToLong()
    {
        assertEquals(l, NumberUtils.toLong("1000000000"));
    }

    public void testLongToLong()
    {
        assertEquals(l, NumberUtils.toLong(new Long(l)));
    }

    public void testIntegerToLong()
    {
        assertEquals(l, NumberUtils.toLong(new Integer(1000000000)));
    }

    public void testIncompatible()
    {
        try
        {
            NumberUtils.toLong(Calendar.getInstance().getTime());
            fail();
        }
        catch (IllegalArgumentException e)
        {
            // expected
        }
    }

    public void testNull()
    {
        try
        {
            // need to cast to Object, otherwise compiler would resolve method to
            // superclass' implementation
            NumberUtils.toLong((Object)null);
            fail();
        }
        catch (IllegalArgumentException e)
        {
            // expected
        }
    }

}
