/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.filters;

import java.util.Arrays;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.RequestContextWrapper;

public class MethodOverrideFilter
implements Filter {
    private String[] methods;

    public MethodOverrideFilter() {
        this("DELETE", "PUT");
    }

    public MethodOverrideFilter(String ... methods) {
        this.setMethods(methods);
    }

    public String[] getMethods() {
        return this.methods;
    }

    public void setMethods(String ... methods) {
        this.methods = methods;
        Arrays.sort(methods);
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        return chain.next(new MethodOverrideRequestContext(request));
    }

    private class MethodOverrideRequestContext
    extends RequestContextWrapper {
        private final String method;

        public MethodOverrideRequestContext(RequestContext request) {
            super(request);
            String method = super.getMethod();
            String xheader = this.getHeader("X-HTTP-Method-Override");
            if (xheader == null) {
                xheader = this.getHeader("X-Method-Override");
            }
            if (xheader != null) {
                xheader = xheader.toUpperCase().trim();
            }
            if (method.equals("POST") && xheader != null && Arrays.binarySearch(MethodOverrideFilter.this.methods, xheader) > -1) {
                method = xheader;
            }
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

