/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.security.Authentication;
import org.mule.api.security.Credentials;
import org.mule.api.security.SecurityContext;
import org.mule.security.DefaultMuleAuthentication;
import org.mule.security.DefaultSecurityContextFactory;
import org.mule.security.MuleCredentials;
import org.mule.session.DefaultMuleSession;
import org.mule.session.LegacySessionHandler;
import org.mule.session.SerializeAndEncodeSessionHandler;
import org.mule.tck.AbstractMuleTestCase;

public class MuleSessionHandlerTestCase
extends AbstractMuleTestCase {
    public void testSessionProperties() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        DefaultMuleSession session = new DefaultMuleSession(muleContext);
        String string = "bar";
        session.setProperty("fooString", (Object)string);
        Date date = new Date(0L);
        session.setProperty("fooDate", (Object)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        Object obj = session.getProperty((Object)"fooString");
        MuleSessionHandlerTestCase.assertTrue((boolean)(obj instanceof String));
        MuleSessionHandlerTestCase.assertEquals((Object)string, (Object)obj);
        obj = session.getProperty((Object)"fooDate");
        MuleSessionHandlerTestCase.assertTrue((String)("Object should be a Date but is " + obj.getClass().getName()), (boolean)(obj instanceof Date));
        MuleSessionHandlerTestCase.assertEquals((Object)date, (Object)obj);
        obj = session.getProperty((Object)"fooList");
        MuleSessionHandlerTestCase.assertTrue((String)("Object should be a List but is " + obj.getClass().getName()), (boolean)(obj instanceof List));
        MuleSessionHandlerTestCase.assertEquals(list, (Object)obj);
    }

    public void testNonSerializableSessionProperties() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        DefaultMuleSession session = new DefaultMuleSession(muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        NotSerializableClass clazz = new NotSerializableClass();
        session.setProperty("foo", (Object)clazz);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        MuleSessionHandlerTestCase.assertNull((Object)session.getProperty((Object)"foo"));
    }

    public void testBackwardsCompatibility() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        LegacySessionHandler legacyHandler = new LegacySessionHandler();
        DefaultMuleSession session = new DefaultMuleSession(muleContext);
        String string = "bar";
        session.setProperty("fooString", (Object)string);
        Date date = new Date(0L);
        session.setProperty("fooDate", (Object)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        legacyHandler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        try {
            session = new SerializeAndEncodeSessionHandler().retrieveSessionInfoFromMessage((MuleMessage)message);
        }
        catch (SerializationException e) {
            // empty catch block
        }
        session = legacyHandler.retrieveSessionInfoFromMessage((MuleMessage)message);
    }

    public void testSessionPropertiesLegacyFormat() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        LegacySessionHandler handler = new LegacySessionHandler();
        DefaultMuleSession session = new DefaultMuleSession(muleContext);
        String string = "bar";
        session.setProperty("fooString", (Object)string);
        Date date = new Date(0L);
        session.setProperty("fooDate", (Object)date);
        List<String> list = this.createList();
        session.setProperty("fooList", list);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        Object obj = session.getProperty((Object)"fooString");
        MuleSessionHandlerTestCase.assertTrue((boolean)(obj instanceof String));
        MuleSessionHandlerTestCase.assertEquals((Object)string, (Object)obj);
        obj = session.getProperty((Object)"fooDate");
        MuleSessionHandlerTestCase.assertTrue((boolean)(obj instanceof String));
        obj = session.getProperty((Object)"fooList");
        MuleSessionHandlerTestCase.assertTrue((boolean)(obj instanceof String));
    }

    public void testSecurityContext() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        DefaultMuleSession session = new DefaultMuleSession(muleContext);
        MuleCredentials credentials = new MuleCredentials("joe", "secret".toCharArray());
        SecurityContext sc = new DefaultSecurityContextFactory().create((Authentication)new DefaultMuleAuthentication((Credentials)credentials));
        session.setSecurityContext(sc);
        handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
        Object s = message.removeProperty("MULE_SESSION");
        message.setInboundProperty("MULE_SESSION", s);
        session = handler.retrieveSessionInfoFromMessage((MuleMessage)message);
        sc = session.getSecurityContext();
        MuleSessionHandlerTestCase.assertEquals((Object)"joe", (Object)sc.getAuthentication().getPrincipal());
    }

    public void testNotSerializableSecurityContext() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        SerializeAndEncodeSessionHandler handler = new SerializeAndEncodeSessionHandler();
        DefaultMuleSession session = new DefaultMuleSession(muleContext);
        session.setSecurityContext((SecurityContext)new NotSerializableSecurityContext());
        try {
            handler.storeSessionInfoToMessage((MuleSession)session, (MuleMessage)message);
            MuleSessionHandlerTestCase.fail((String)"Should throw a SerializationException");
        }
        catch (SerializationException e) {
            // empty catch block
        }
    }

    private List<String> createList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("bar1");
        list.add("bar2");
        return list;
    }

    private class NotSerializableSecurityContext
    implements SecurityContext {
        public void setAuthentication(Authentication authentication) {
        }

        public Authentication getAuthentication() {
            return null;
        }
    }

    private class NotSerializableClass {
    }
}

