/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import java.util.Arrays;
import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.model.EntryPointResolver;
import org.mule.model.resolvers.ArrayEntryPointResolver;
import org.mule.model.resolvers.EntryPointNotFoundException;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitCleaner;
import org.mule.tck.testmodels.fruit.FruitLover;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;

public class LegacyEntryPointResolverTestCase
extends AbstractMuleTestCase {
    private static final String METHOD_PROPERTY_NAME = "method";
    private static final String INVALID_METHOD_NAME = "nosuchmethod";

    public void testExplicitMethodMatch() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            resolver.invoke((Object)new WaterMelon(), LegacyEntryPointResolverTestCase.getTestEventContext("blah"));
        }
        catch (MuleException e) {
            LegacyEntryPointResolverTestCase.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    public void testExplicitMethodMatchComplexObject() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            resolver.invoke((Object)new FruitBowl(), LegacyEntryPointResolverTestCase.getTestEventContext(new FruitLover("Mmmm")));
        }
        catch (MuleException e) {
            LegacyEntryPointResolverTestCase.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    public void testExplicitMethodMatchSetArrayFail() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            resolver.invoke((Object)new FruitBowl(), LegacyEntryPointResolverTestCase.getTestEventContext(new Fruit[]{new Apple(), new Orange()}));
            LegacyEntryPointResolverTestCase.fail((String)"Test should have failed because the arguments were not wrapped properly: ");
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }

    public void testExplicitMethodMatchSetArrayPass() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            resolver.invoke((Object)new FruitBowl(), LegacyEntryPointResolverTestCase.getTestEventContext(new Object[]{new Fruit[]{new Apple(), new Orange()}}));
        }
        catch (MuleException e) {
            LegacyEntryPointResolverTestCase.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    public void testExplicitMethodMatchSetArrayPassUsingExplicitResolver() throws Exception {
        try {
            LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
            resolver.addEntryPointResolver((EntryPointResolver)new ArrayEntryPointResolver());
            resolver.invoke((Object)new FruitBowl(), LegacyEntryPointResolverTestCase.getTestEventContext(new Fruit[]{new Apple(), new Orange()}));
        }
        catch (MuleException e) {
            LegacyEntryPointResolverTestCase.fail((String)("Test should have passed: " + (Object)((Object)e)));
        }
    }

    public void testFailEntryPointMultiplePayloadMatches() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        try {
            RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent("Hello"));
            resolverSet.invoke((Object)new MultiplePayloadsTestObject(), RequestContext.getEventContext());
            LegacyEntryPointResolverTestCase.fail((String)"Should have failed to find entrypoint.");
        }
        catch (EntryPointNotFoundException entryPointNotFoundException) {
            // empty catch block
        }
    }

    public void testMethodOverrideDoesNotFallback() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent(new FruitLover("Yummy!")));
        String methodName = INVALID_METHOD_NAME;
        String propertyName = METHOD_PROPERTY_NAME;
        RequestContext.getEventContext().getMessage().setOutboundProperty(METHOD_PROPERTY_NAME, (Object)INVALID_METHOD_NAME);
        resolverSet.invoke((Object)new FruitBowl(), RequestContext.getEventContext());
    }

    public void testMethodOverrideIgnoredWithCallable() throws Exception {
        LegacyEntryPointResolverSet resolver = new LegacyEntryPointResolverSet();
        RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent(new FruitLover("Yummy!")));
        RequestContext.getEventContext().getMessage().setOutboundProperty(METHOD_PROPERTY_NAME, (Object)INVALID_METHOD_NAME);
        Apple apple = new Apple();
        apple.setAppleCleaner(new FruitCleaner(){

            @Override
            public void wash(Fruit fruit) {
            }

            @Override
            public void polish(Fruit fruit) {
            }
        });
        resolver.invoke((Object)apple, RequestContext.getEventContext());
    }

    public void testMethodOverrideIgnoredWithEventContext() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent(new FruitLover("Yummy!")));
        String methodName = INVALID_METHOD_NAME;
        String propertyName = METHOD_PROPERTY_NAME;
        RequestContext.getEventContext().getMessage().setOutboundProperty(METHOD_PROPERTY_NAME, (Object)INVALID_METHOD_NAME);
        try {
            resolverSet.invoke((Object)new Kiwi(), RequestContext.getEventContext());
            LegacyEntryPointResolverTestCase.fail((String)"no such method on service");
        }
        catch (EntryPointNotFoundException e) {
            // empty catch block
        }
    }

    public void testArrayArgumentResolution() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        Object[] payload = new Object[]{new Fruit[]{new Apple(), new Banana()}};
        RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent(payload));
        FruitBowl bowl = new FruitBowl();
        LegacyEntryPointResolverTestCase.assertFalse((boolean)bowl.hasApple());
        LegacyEntryPointResolverTestCase.assertFalse((boolean)bowl.hasBanana());
        resolverSet.invoke((Object)bowl, RequestContext.getEventContext());
        LegacyEntryPointResolverTestCase.assertTrue((boolean)bowl.hasApple());
        LegacyEntryPointResolverTestCase.assertTrue((boolean)bowl.hasBanana());
    }

    public void testListArgumentResolution() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        List<Fruit> payload = Arrays.asList(new Apple(), new Banana());
        RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent(payload));
        FruitBowl bowl = new FruitBowl();
        LegacyEntryPointResolverTestCase.assertFalse((boolean)bowl.hasApple());
        LegacyEntryPointResolverTestCase.assertFalse((boolean)bowl.hasBanana());
        resolverSet.invoke((Object)bowl, RequestContext.getEventContext());
        LegacyEntryPointResolverTestCase.assertTrue((boolean)bowl.hasApple());
        LegacyEntryPointResolverTestCase.assertTrue((boolean)bowl.hasBanana());
    }

    public void testExplicitOverride() throws Exception {
        LegacyEntryPointResolverSet resolverSet = new LegacyEntryPointResolverSet();
        List<Fruit> payload = Arrays.asList(new Apple(), new Banana());
        RequestContext.setEvent((MuleEvent)LegacyEntryPointResolverTestCase.getTestEvent(payload));
        String methodName = "setFruit";
        String propertyName = METHOD_PROPERTY_NAME;
        RequestContext.getEventContext().getMessage().setOutboundProperty(METHOD_PROPERTY_NAME, (Object)"setFruit");
        FruitBowl bowl = new FruitBowl();
        LegacyEntryPointResolverTestCase.assertFalse((boolean)bowl.hasApple());
        LegacyEntryPointResolverTestCase.assertFalse((boolean)bowl.hasBanana());
        resolverSet.invoke((Object)bowl, RequestContext.getEventContext());
        LegacyEntryPointResolverTestCase.assertTrue((boolean)bowl.hasApple());
        LegacyEntryPointResolverTestCase.assertTrue((boolean)bowl.hasBanana());
    }
}

