/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.registry.AbstractLifecycleTracker;
import org.mule.registry.TransientRegistry;
import org.mule.registry.TransientRegistryTestCase;

public class TransientRegistryLifecycleTestCase
extends TransientRegistryTestCase {
    public void testObjectLifecycleWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.dispose();
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycleWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)1);
        reg.dispose();
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassInjectorsWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)2);
        reg.dispose();
        TransientRegistryLifecycleTestCase.assertEquals((String)"[initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycleAndInjectorsWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)3);
        reg.dispose();
        TransientRegistryLifecycleTestCase.assertEquals((String)"[stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectLifecycleStatesWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext]", (String)tracker.getTracker().toString());
        reg.initialise();
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("start");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        try {
            reg.fireLifecycle("start");
            TransientRegistryLifecycleTestCase.fail((String)"Registry is already started");
        }
        catch (Exception e) {
            // empty catch block
        }
        reg.fireLifecycle("stop");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        try {
            reg.fireLifecycle("stop");
            TransientRegistryLifecycleTestCase.fail((String)"Registry is already stopped");
        }
        catch (Exception e) {
            // empty catch block
        }
        reg.dispose();
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
        try {
            reg.dispose();
            TransientRegistryLifecycleTestCase.fail((String)"Registry is already disposed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLifecycleState() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("initialise");
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceStartFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        try {
            reg.fireLifecycle("start");
            TransientRegistryLifecycleTestCase.fail((String)"Cannot start without initialising first");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.fireLifecycle("initialise");
        reg.fireLifecycle("start");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceStopFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        try {
            reg.fireLifecycle("stop");
            TransientRegistryLifecycleTestCase.fail((String)"Cannot stop without starting first");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.fireLifecycle("initialise");
        reg.fireLifecycle("start");
        reg.fireLifecycle("stop");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        TransientRegistryLifecycleTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public class JSR250ObjectLifecycleTracker
    implements MuleContextAware {
        private final List<String> tracker = new ArrayList<String>();

        public List<String> getTracker() {
            return this.tracker;
        }

        public void setMuleContext(MuleContext context) {
            this.tracker.add("setMuleContext");
        }

        @PostConstruct
        public void init() {
            this.tracker.add("initialise");
        }

        @PreDestroy
        public void dispose() {
            this.tracker.add("dispose");
        }
    }

    public class InterfaceBasedTracker
    extends AbstractLifecycleTracker {
    }
}

