/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.ExceptionBasedRouter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class ExceptionBasedRouterTestCase
extends AbstractMuleTestCase {
    public ExceptionBasedRouterTestCase() {
        this.setStartContext(true);
    }

    public void testSuccessfulExceptionRouterSynchronous() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getFlowConstruct", (Object)ExceptionBasedRouterTestCase.getTestService());
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = muleContext.getEndpointFactory().getOutboundEndpoint("test://Dummy1?exchangePattern=request-response");
        OutboundEndpoint endpoint2 = muleContext.getEndpointFactory().getOutboundEndpoint("test://Dummy2?exchangePattern=request-response");
        OutboundEndpoint endpoint3 = muleContext.getEndpointFactory().getOutboundEndpoint("test://Dummy3?exchangePattern=request-response");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        Mock mockendpoint3 = RouterTestUtils.getMockEndpoint(endpoint3);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint2.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint3.proxy());
        router.setRoutes(endpoints);
        ExceptionBasedRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)mockSession.proxy(), muleContext));
        ExceptionBasedRouterTestCase.assertNotNull((Object)result);
        ExceptionBasedRouterTestCase.assertEquals((Object)message, (Object)result.getMessage());
        mockendpoint1.verify();
    }

    public void testBothFailing() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getFlowConstruct", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = muleContext.getEndpointFactory().getOutboundEndpoint("test://AlwaysFail");
        OutboundEndpoint endpoint2 = muleContext.getEndpointFactory().getOutboundEndpoint("test://AlwaysFail");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint2.proxy());
        router.setRoutes(endpoints);
        ExceptionBasedRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)mockSession.proxy();
        DefaultMuleEvent eventToThrow = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, session);
        RoutingException rex = new RoutingException((MuleEvent)eventToThrow, (MessageProcessor)endpoint1);
        mockendpoint1.expectAndThrow("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Throwable)rex);
        mockendpoint2.expectAndThrow("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Throwable)rex);
        MuleEvent result = null;
        try {
            result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
            ExceptionBasedRouterTestCase.fail((String)"Should have thrown exception as both targets would have failed");
        }
        catch (CouldNotRouteOutboundMessageException e) {
            // empty catch block
        }
        ExceptionBasedRouterTestCase.assertNull((String)"Async call should've returned null.", result);
        mockSession.verify();
        message = new DefaultMuleMessage((Object)"test event", muleContext);
    }

    public void testFailFirstSuccessSecondSync() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getFlowConstruct", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?exchangePattern=request-response");
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?exchangePattern=request-response");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint1.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint2.proxy()));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)expectedResultMessage, null, muleContext);
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)mockSession.proxy();
        DefaultMuleEvent eventToThrow = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, session);
        RoutingException rex = new RoutingException((MuleEvent)eventToThrow, (MessageProcessor)endpoint1);
        mockendpoint1.expectAndThrow("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Throwable)rex);
        mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent actualResult = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        mockendpoint1.verify();
        mockendpoint2.verify();
        ExceptionBasedRouterTestCase.assertEquals((String)"Got an invalid return message.", (Object)expectedResultMessage, (Object)actualResult.getMessage());
    }

    public void testFailFirstSuccessSecondAsync() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getFlowConstruct", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?exchangePattern=request-response");
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?exchangePattern=one-way");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint1.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint2.proxy()));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)expectedResultMessage, null, muleContext);
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)mockSession.proxy();
        DefaultMuleEvent eventToThrow = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, session);
        RoutingException rex = new RoutingException((MuleEvent)eventToThrow, (MessageProcessor)endpoint1);
        mockendpoint1.expectAndThrow("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Throwable)rex);
        mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent actualResult = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        ExceptionBasedRouterTestCase.assertNull((String)"Async call should not return any results.", (Object)actualResult);
        mockendpoint1.verify();
        mockendpoint2.verify();
    }

    public void testFirstHadExceptionPayloadSuccessSecondSyncWithExceptionPayload() throws Exception {
        Mock mockSession = MuleTestUtils.getMockSession();
        mockSession.matchAndReturn("getFlowConstruct", (Object)ExceptionBasedRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?exchangePattern=request-response");
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?exchangePattern=request-response");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint1.proxy()));
        router.addRoute((MessageProcessor)((OutboundEndpoint)mockendpoint2.proxy()));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event", muleContext);
        OutboundRoutingTestEvent expectedResultEvent = new OutboundRoutingTestEvent((MuleMessage)expectedResultMessage, null, muleContext);
        ExceptionBasedRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        DefaultMuleMessage exPayloadMessage = new DefaultMuleMessage((Object)"there was a failure", muleContext);
        exPayloadMessage.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        OutboundRoutingTestEvent exPayloadMessageEvent = new OutboundRoutingTestEvent((MuleMessage)exPayloadMessage, null, muleContext);
        MuleSession session = (MuleSession)mockSession.proxy();
        mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)exPayloadMessageEvent);
        mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)expectedResultEvent);
        MuleEvent actualResult = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        mockendpoint1.verify();
        mockendpoint2.verify();
        ExceptionBasedRouterTestCase.assertEquals((String)"Got an invalid return message.", (Object)expectedResultMessage, (Object)actualResult.getMessage());
    }
}

