/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.routing.outbound.SequenceRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class SequenceRouterTestCase
extends AbstractMuleTestCase {
    private Mock session;
    private SequenceRouter router;
    private Mock mockEndpoint1;
    private Mock mockEndpoint2;

    @Override
    protected void doSetUp() throws Exception {
        this.session = MuleTestUtils.getMockSession();
        this.session.matchAndReturn("getFlowConstruct", (Object)SequenceRouterTestCase.getTestService());
        this.session.matchAndReturn("setFlowConstruct", (ConstraintMatcher)RouterTestUtils.getArgListCheckerFlowConstruct(), null);
        OutboundEndpoint endpoint1 = SequenceRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        OutboundEndpoint endpoint2 = SequenceRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?exchangePattern=request-response");
        this.mockEndpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        this.mockEndpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        this.router = this.createObject(SequenceRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)this.mockEndpoint1.proxy());
        endpoints.add((OutboundEndpoint)this.mockEndpoint2.proxy());
        this.router.setRoutes(endpoints);
    }

    public void testSyncEndpointsOk() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        this.mockEndpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        this.mockEndpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy(), muleContext));
        SequenceRouterTestCase.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        SequenceRouterTestCase.assertNotNull((Object)resultMessage);
        SequenceRouterTestCase.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        SequenceRouterTestCase.assertEquals((int)2, (int)((MuleMessageCollection)resultMessage).size());
        this.mockEndpoint1.verify();
        this.mockEndpoint2.verify();
    }

    public void testSyncEndpointsWithFirstOneFailing() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        OutboundRoutingTestEvent eventWithNullMessage = new OutboundRoutingTestEvent(null, null, muleContext);
        this.mockEndpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)eventWithNullMessage);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy(), muleContext));
        SequenceRouterTestCase.assertNull((Object)result);
    }

    public void testSyncEndpointsWithLastOneFailing() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        OutboundRoutingTestEvent eventWithNullMessage = new OutboundRoutingTestEvent(null, null, muleContext);
        this.mockEndpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        this.mockEndpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)eventWithNullMessage);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy(), muleContext));
        SequenceRouterTestCase.assertNotNull((Object)result);
        SequenceRouterTestCase.assertTrue((boolean)(result instanceof MuleEvent));
    }
}

