/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ExternalResource;
import org.mule.tck.junit4.rule.FreePortFinder;

public class DynamicPort
extends ExternalResource {
    private static final int MIN_PORT = 5000;
    private static final int MAX_PORT = 6000;
    protected static FreePortFinder freePortFinder = new FreePortFinder(5000, 6000);
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final String name;
    private int number;
    private boolean initialized = false;

    public DynamicPort(String name) {
        this.name = name;
    }

    public void before() throws Throwable {
        if (this.initialized) {
            throw new IllegalArgumentException("Dynamic port was already initialized");
        }
        this.number = freePortFinder.find();
        System.setProperty(this.name, String.valueOf(this.number));
        this.initialized = true;
    }

    public void after() {
        if (!this.initialized) {
            throw new IllegalArgumentException("Dynamic port was not initialized");
        }
        freePortFinder.releasePort(this.number);
        this.initialized = false;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }
}

