/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.encryption;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.mule.api.EncryptionStrategy;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.transformer.Transformer;
import org.mule.security.PasswordBasedEncryptionStrategy;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.encryption.DecryptionTransformer;
import org.mule.transformer.encryption.EncryptionTransformer;

public class EncryptionTransformerTestCase
extends AbstractTransformerTestCase {
    private static final String TEST_DATA = "the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog";
    private PasswordBasedEncryptionStrategy strat;

    @Override
    protected void doSetUp() throws Exception {
        this.strat = new PasswordBasedEncryptionStrategy();
        this.strat.setPassword("mule");
        this.strat.initialise();
    }

    @Override
    public Object getResultData() {
        try {
            return new ByteArrayInputStream(this.strat.encrypt(TEST_DATA.getBytes(), null));
        }
        catch (CryptoFailureException e) {
            EncryptionTransformerTestCase.fail((String)e.getMessage());
            return null;
        }
    }

    @Override
    public Object getTestData() {
        return new ByteArrayInputStream(TEST_DATA.getBytes());
    }

    @Override
    public Transformer getTransformer() {
        EncryptionTransformer transformer = new EncryptionTransformer();
        transformer.setStrategy((EncryptionStrategy)this.strat);
        try {
            transformer.initialise();
        }
        catch (InitialisationException e) {
            EncryptionTransformerTestCase.fail((String)e.getMessage());
        }
        return transformer;
    }

    @Override
    public Transformer getRoundTripTransformer() {
        DecryptionTransformer transformer = new DecryptionTransformer();
        transformer.setStrategy((EncryptionStrategy)this.strat);
        try {
            transformer.initialise();
        }
        catch (InitialisationException e) {
            EncryptionTransformerTestCase.fail((String)e.getMessage());
        }
        return transformer;
    }

    @Override
    public boolean compareResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        if (src instanceof byte[] && result instanceof byte[]) {
            return Arrays.equals((byte[])src, (byte[])result);
        }
        return super.compareResults(src, result);
    }
}

