/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.simple.ByteArrayToHexString;
import org.mule.transformer.simple.HexStringToByteArray;

public class HexStringByteArrayTransformersTestCase
extends AbstractTransformerTestCase {
    @Override
    public Transformer getTransformer() {
        return new HexStringToByteArray();
    }

    @Override
    public Transformer getRoundTripTransformer() {
        return new ByteArrayToHexString();
    }

    @Override
    public Object getTestData() {
        return "01020aff";
    }

    @Override
    public Object getResultData() {
        return new byte[]{1, 2, 10, -1};
    }

    @Override
    public boolean compareResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        return Arrays.equals((byte[])src, (byte[])result);
    }

    @Override
    public boolean compareRoundtripResults(Object src, Object result) {
        if (src == null && result == null) {
            return true;
        }
        if (src == null || result == null) {
            return false;
        }
        return src.equals(result);
    }

    public void testUppercase() throws TransformerException {
        ByteArrayToHexString t = new ByteArrayToHexString();
        t.setUpperCase(true);
        HexStringByteArrayTransformersTestCase.assertEquals((Object)((String)this.getTestData()).toUpperCase(), (Object)t.transform(this.getResultData()));
    }

    public void testStreaming() throws TransformerException {
        ByteArrayToHexString transformer = new ByteArrayToHexString();
        ByteArrayInputStream input = new ByteArrayInputStream((byte[])this.getResultData());
        HexStringByteArrayTransformersTestCase.assertEquals((Object)this.getTestData(), (Object)transformer.transform((Object)input));
    }
}

