/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.transformer.Transformer;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.simple.ObjectArrayToString;
import org.mule.transformer.simple.StringToObjectArray;

public class StringObjectArrayTransformersTestCase
extends AbstractTransformerTestCase {
    @Override
    public Transformer getTransformer() throws Exception {
        return new StringToObjectArray();
    }

    @Override
    public Transformer getRoundTripTransformer() throws Exception {
        return new ObjectArrayToString();
    }

    @Override
    public Object getTestData() {
        return "test1 test2 test3";
    }

    @Override
    public Object getResultData() {
        return new String[]{"test1", "test2", "test3"};
    }

    @Override
    public boolean compareResults(Object src, Object result) {
        if (src == null || result == null) {
            return false;
        }
        if (result instanceof Object[]) {
            Object[] out = (Object[])result;
            StringObjectArrayTransformersTestCase.assertEquals((String)out[0].toString(), (String)"test1");
            StringObjectArrayTransformersTestCase.assertEquals((String)out[1].toString(), (String)"test2");
            StringObjectArrayTransformersTestCase.assertEquals((String)out[2].toString(), (String)"test3");
            return true;
        }
        return false;
    }

    @Override
    public boolean compareRoundtripResults(Object src, Object result) {
        if (src == null || result == null) {
            return false;
        }
        return src.equals(result);
    }
}

