/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import org.mule.api.DefaultMuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.api.transport.MessageRequesterFactory;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transport.AbstractConnector;

public abstract class AbstractConnectorTestCase
extends AbstractMuleTestCase {
    protected String connectorName;
    protected String encoding;

    @Override
    protected void doSetUp() throws Exception {
        Connector connector = this.createConnector();
        if (connector.getName() == null) {
            connector.setName("test");
        }
        this.connectorName = connector.getName();
        muleContext.getRegistry().registerConnector(connector);
        this.encoding = muleContext.getConfiguration().getDefaultEncoding();
    }

    @Override
    protected void doTearDown() throws Exception {
        Connector connector = this.getConnector();
        if (connector.isDisposed()) {
            AbstractConnectorTestCase.fail((String)("Connector has been disposed prematurely - lifecycle problem? Instance: " + connector));
        }
    }

    protected Connector getConnector() {
        return muleContext.getRegistry().lookupConnector(this.connectorName);
    }

    protected Connector getConnectorAndAssert() {
        Connector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        return connector;
    }

    public void testConnectorExceptionHandling() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        Mock ehandlerMock = new Mock(SystemExceptionHandler.class, "exceptionHandler");
        ehandlerMock.expect("handleException", (Object)C.isA(Exception.class));
        AbstractConnectorTestCase.assertNotNull((Object)muleContext.getExceptionListener());
        muleContext.setExceptionListener((SystemExceptionHandler)ehandlerMock.proxy());
        muleContext.getExceptionListener().handleException((Exception)new DefaultMuleException(MessageFactory.createStaticMessage((String)"Dummy")));
        if (connector instanceof AbstractConnector) {
            ehandlerMock.expect("handleException", (Object)C.isA(Exception.class));
            muleContext.getExceptionListener().handleException((Exception)new DefaultMuleException(MessageFactory.createStaticMessage((String)"Dummy")));
        }
        ehandlerMock.verify();
        muleContext.setExceptionListener(null);
        try {
            muleContext.getExceptionListener().handleException((Exception)new DefaultMuleException(MessageFactory.createStaticMessage((String)"Dummy")));
            AbstractConnectorTestCase.fail((String)"Should have thrown exception as no strategy is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConnectorLifecycle() throws Exception {
        Connector localConnector = this.createConnector();
        localConnector.setName(this.connectorName + "-temp");
        localConnector.initialise();
        localConnector.start();
        AbstractConnectorTestCase.assertNotNull((Object)localConnector);
        AbstractConnectorTestCase.assertTrue((boolean)localConnector.isStarted());
        AbstractConnectorTestCase.assertTrue((!localConnector.isDisposed() ? 1 : 0) != 0);
        localConnector.stop();
        AbstractConnectorTestCase.assertTrue((!localConnector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((!localConnector.isDisposed() ? 1 : 0) != 0);
        localConnector.dispose();
        AbstractConnectorTestCase.assertTrue((!localConnector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((boolean)localConnector.isDisposed());
        try {
            localConnector.start();
            AbstractConnectorTestCase.fail((String)"Connector cannot be restarted after being disposing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnectorListenerSupport() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        Service service = AbstractConnectorTestCase.getTestService("anApple", Apple.class);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint(this.getTestEndpointURI());
        try {
            connector.registerListener(null, null, (FlowConstruct)service);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.registerListener(endpoint, null, (FlowConstruct)service);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.registerListener(null, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        connector.registerListener(endpoint, (MessageProcessor)this.getSensingNullMessageProcessor(), (FlowConstruct)service);
        connector.unregisterListener(endpoint, (FlowConstruct)service);
        try {
            connector.unregisterListener(null, (FlowConstruct)service);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.unregisterListener(null, (FlowConstruct)service);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.unregisterListener(null, (FlowConstruct)service);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        connector.unregisterListener(endpoint, (FlowConstruct)service);
        muleContext.getRegistry().unregisterService(service.getName());
    }

    public void testConnectorBeanProps() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        try {
            connector.setName(null);
            AbstractConnectorTestCase.fail((String)"Should throw IllegalArgumentException if name set to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        connector.setName("Test");
        AbstractConnectorTestCase.assertEquals((String)"Test", (String)connector.getName());
        AbstractConnectorTestCase.assertNotNull((String)"Protocol must be set as a constant", (Object)connector.getProtocol());
    }

    public void testConnectorMuleMessageFactory() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        MuleMessageFactory factory = connector.createMuleMessageFactory();
        AbstractConnectorTestCase.assertNotNull((Object)factory);
    }

    public void testConnectorMessageDispatcherFactory() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        MessageDispatcherFactory factory = connector.getDispatcherFactory();
        AbstractConnectorTestCase.assertNotNull((Object)factory);
    }

    public void testConnectorMessageRequesterFactory() throws Exception {
        Connector connector = this.getConnectorAndAssert();
        MessageRequesterFactory factory = connector.getRequesterFactory();
        AbstractConnectorTestCase.assertNotNull((Object)factory);
    }

    public void testConnectorInitialise() throws Exception {
        Connector connector = this.getConnector();
        try {
            connector.initialise();
            AbstractConnectorTestCase.fail((String)"A connector cannot be initialised more than once");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract Connector createConnector() throws Exception;

    public abstract Object getValidMessage() throws Exception;

    public abstract String getTestEndpointURI();
}

