/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.config.ImmutableThreadingProfile;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;

public class DispatcherPoolTestCase
extends AbstractMuleTestCase {
    public void testDefaultDispatcherPoolConfiguration() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(4);
        DispatcherPoolTestCase.assertEquals((int)4, (int)connector.getDispatcherThreadingProfile().getPoolExhaustedAction());
        DispatcherPoolTestCase.assertEquals((int)2, (int)connector.dispatchers.getMaxActive());
        DispatcherPoolTestCase.assertEquals((int)2, (int)connector.dispatchers.getMaxIdle());
        DispatcherPoolTestCase.assertEquals((byte)1, (byte)connector.dispatchers.getWhenExhaustedAction());
        DispatcherPoolTestCase.assertEquals((long)-1L, (long)connector.dispatchers.getMaxWait());
    }

    public void testDefaultDispatcherPoolConfigurationThreadingProfileWait() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        DispatcherPoolTestCase.assertEquals((int)0, (int)connector.getDispatcherThreadingProfile().getPoolExhaustedAction());
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getMaxActive());
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getMaxIdle());
        DispatcherPoolTestCase.assertEquals((byte)1, (byte)connector.dispatchers.getWhenExhaustedAction());
        DispatcherPoolTestCase.assertEquals((long)-1L, (long)connector.dispatchers.getMaxWait());
    }

    public void testDispatcherPoolDefaultBlockExhaustedAction() throws Exception {
        final TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolMaxWait(100);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getMaxActive());
        DispatcherPoolTestCase.assertEquals((long)100L, (long)connector.dispatchers.getMaxWait());
        final OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDispatcher messageDispatcher = (MessageDispatcher)connector.dispatchers.borrowObject((Object)endpoint);
                    Thread.sleep(50L);
                    connector.dispatchers.returnObject((Object)endpoint, (Object)messageDispatcher);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        Thread.sleep(10L);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getNumActive());
        connector.dispatchers.borrowObject((Object)endpoint);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getNumActive());
    }

    public void testDispatcherPoolBlockTimeoutExhaustedAction() throws Exception {
        final TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolMaxWait(10);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getMaxActive());
        DispatcherPoolTestCase.assertEquals((long)10L, (long)connector.dispatchers.getMaxWait());
        final OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDispatcher messageDispatcher = (MessageDispatcher)connector.dispatchers.borrowObject((Object)endpoint);
                    Thread.sleep(200L);
                    connector.dispatchers.returnObject((Object)endpoint, (Object)messageDispatcher);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        Thread.sleep(10L);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getNumActive());
        try {
            connector.dispatchers.borrowObject((Object)endpoint);
            DispatcherPoolTestCase.fail((String)"Exception expected");
        }
        catch (Exception e) {
            DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getNumActive());
        }
    }

    public void testDispatcherPoolGrowExhaustedAction() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolWhenExhaustedAction((byte)2);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getMaxActive());
        OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        connector.dispatchers.borrowObject((Object)endpoint);
        connector.dispatchers.borrowObject((Object)endpoint);
        DispatcherPoolTestCase.assertEquals((int)2, (int)connector.dispatchers.getNumActive());
    }

    public void testDispatcherPoolFailExhaustedAction() throws Exception {
        TestConnector connector = this.createConnectorWithSingleObjectDispatcherPool(0);
        connector.setDispatcherPoolWhenExhaustedAction((byte)0);
        DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getMaxActive());
        OutboundEndpoint endpoint = DispatcherPoolTestCase.getTestOutboundEndpoint("test", "test://test");
        connector.dispatchers.borrowObject((Object)endpoint);
        try {
            connector.dispatchers.borrowObject((Object)endpoint);
            DispatcherPoolTestCase.fail((String)"Exception expected");
        }
        catch (Exception e) {
            DispatcherPoolTestCase.assertEquals((int)1, (int)connector.dispatchers.getNumActive());
        }
    }

    private TestConnector createConnectorWithSingleObjectDispatcherPool(int exhaustedAction) throws Exception {
        TestConnector connector = new TestConnector(muleContext);
        ImmutableThreadingProfile threadingProfile = new ImmutableThreadingProfile(1, 1, 1, 1L, 1L, exhaustedAction, true, null, null);
        connector.setDispatcherThreadingProfile((ThreadingProfile)threadingProfile);
        connector.createReceiver((FlowConstruct)DispatcherPoolTestCase.getTestService(), DispatcherPoolTestCase.getTestInboundEndpoint("test", "test://test"));
        muleContext.getRegistry().registerConnector((Connector)connector);
        return connector;
    }
}

