/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.OrangeInterface;
import org.mule.util.BeanUtils;

public class BeanUtilsTestCase
extends AbstractMuleTestCase {
    private Map<String, String> map;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.map = new HashMap<String, String>();
        this.map.put("brand", "Juicy!");
        this.map.put("radius", "2.32");
        this.map.put("segments", "22");
        this.map.put("trombones", "3");
    }

    public void testBeanPropertiesOnAProxy() throws Exception {
        OrangeInterface o = (OrangeInterface)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{OrangeInterface.class}, (InvocationHandler)new OrangeInvocationHandler(new Orange()));
        BeanUtils.populateWithoutFail((Object)o, this.map, (boolean)true);
        BeanUtilsTestCase.assertNotNull((Object)o);
        BeanUtilsTestCase.assertEquals((String)"Juicy!", (String)o.getBrand());
        BeanUtilsTestCase.assertEquals((Object)new Double(2.32), (Object)o.getRadius());
        BeanUtilsTestCase.assertEquals((Object)new Integer(22), (Object)o.getSegments());
    }

    public void testBeanPropertiesWithoutFail() throws Exception {
        Orange o = new Orange();
        BeanUtils.populateWithoutFail((Object)o, this.map, (boolean)true);
        BeanUtilsTestCase.assertNotNull((Object)o);
        BeanUtilsTestCase.assertEquals((String)"Juicy!", (String)o.getBrand());
        BeanUtilsTestCase.assertEquals((Object)new Double(2.32), (Object)o.getRadius());
        BeanUtilsTestCase.assertEquals((Object)new Integer(22), (Object)o.getSegments());
    }

    public void testBeanPropertiesWithFail() throws Exception {
        try {
            BeanUtils.populate((Object)new Orange(), this.map);
            BeanUtilsTestCase.fail((String)"Trombones is not a valid property");
        }
        catch (IllegalArgumentException e) {
            BeanUtilsTestCase.assertTrue((e.getMessage().indexOf("trombone") > -1 ? 1 : 0) != 0);
        }
    }

    private class OrangeInvocationHandler
    implements InvocationHandler {
        private Orange orange;

        public OrangeInvocationHandler(Orange orange) {
            this.orange = orange;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.orange, args);
        }
    }
}

