/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.NamedThreadFactory;

public class NamedThreadFactoryTestCase
extends AbstractMuleTestCase {
    protected Latch latch = new Latch();
    protected String testThreadName = "myThread";
    protected ClassLoader testClassLoader = new ClassLoader(){};
    protected Runnable nullRunnable = new Runnable(){

        @Override
        public void run() {
        }
    };

    public void testNameContextClassloader() throws InterruptedException {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.testThreadName, this.testClassLoader);
        Thread t = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                Assert.assertEquals((String)(NamedThreadFactoryTestCase.this.testThreadName + ".01"), (String)Thread.currentThread().getName());
                Assert.assertEquals((Object)NamedThreadFactoryTestCase.this.testClassLoader, (Object)Thread.currentThread().getContextClassLoader());
                NamedThreadFactoryTestCase.this.latch.countDown();
            }
        });
        t.start();
        NamedThreadFactoryTestCase.assertTrue((boolean)this.latch.await(200L, TimeUnit.MILLISECONDS));
    }

    public void testNameIncrement() throws InterruptedException {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.testThreadName);
        Thread t = threadFactory.newThread(this.nullRunnable);
        NamedThreadFactoryTestCase.assertEquals((String)(this.testThreadName + ".01"), (String)t.getName());
        t = threadFactory.newThread(this.nullRunnable);
        NamedThreadFactoryTestCase.assertEquals((String)(this.testThreadName + ".02"), (String)t.getName());
        t = threadFactory.newThread(this.nullRunnable);
        NamedThreadFactoryTestCase.assertEquals((String)(this.testThreadName + ".03"), (String)t.getName());
    }
}

