/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractObjectStoreContractTestCase
extends AbstractMuleTestCase {
    public void testContainsWithNullKey() {
        try {
            this.getObjectStore().contains(null);
            AbstractObjectStoreContractTestCase.fail((String)"contains() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    public void testStoreWithNullKey() {
        try {
            Serializable value = this.getStorableValue();
            this.getObjectStore().store(null, value);
            AbstractObjectStoreContractTestCase.fail((String)"store() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    public void testRetrieveWithNullKey() {
        try {
            this.getObjectStore().retrieve(null);
            AbstractObjectStoreContractTestCase.fail((String)"retrieve() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    public void testRemoveWithNullKey() {
        try {
            this.getObjectStore().remove(null);
            AbstractObjectStoreContractTestCase.fail((String)"remove() called with null key must throw ObjectStoreException");
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    public void testRetrieveUnboundKey() throws ObjectStoreException {
        try {
            Serializable key = this.createKey();
            this.getObjectStore().retrieve(key);
            AbstractObjectStoreContractTestCase.fail((String)"retrieve() with unbound key must throw ObjectDoesNotExistException");
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
    }

    public void testRemoveWithUnboundKey() throws ObjectStoreException {
        try {
            Serializable key = this.createKey();
            this.getObjectStore().remove(key);
            AbstractObjectStoreContractTestCase.fail((String)"remove() with unbound key must throw ObjectDoesNotExistException");
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            // empty catch block
        }
    }

    public void testStoreWithExistingKey() throws ObjectStoreException {
        Serializable key = this.createKey();
        Serializable value = this.getStorableValue();
        ObjectStore<Serializable> objectStore = this.getObjectStore();
        objectStore.store(key, value);
        try {
            objectStore.store(key, value);
            AbstractObjectStoreContractTestCase.fail((String)"store() with an existing key must throw ObjectAlreadyExistsException");
        }
        catch (ObjectAlreadyExistsException oaee) {
            // empty catch block
        }
    }

    protected Serializable createKey() {
        return "theKey";
    }

    public abstract ObjectStore<Serializable> getObjectStore() throws ObjectStoreException;

    public abstract Serializable getStorableValue();
}

