/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ContinuousPollingReceiverWorker;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.TransactedPollingMessageReceiver;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageReceiver
extends TransactedPollingMessageReceiver {
    private VMConnector connector;

    public VMMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setReceiveMessagesInTransaction(endpoint.getTransactionConfig().isTransacted());
        this.connector = (VMConnector)connector;
    }

    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            super.schedule();
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (!this.endpoint.getExchangePattern().hasResponse()) {
            QueueSession queueSession = this.connector.getQueueSession();
            Queue q = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current queue depth for queue: " + this.endpoint.getEndpointURI().getAddress() + " is: " + q.size()));
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    public void onMessage(MuleMessage message) throws MuleException {
        DefaultMuleMessage newMessage = new DefaultMuleMessage(message.getPayload(), message, this.connector.getMuleContext());
        this.routeMessage((MuleMessage)newMessage);
    }

    public MuleMessage onCall(MuleMessage message) throws MuleException {
        try {
            MuleMessage returnedMessage;
            MuleMessage newMessage = message.createInboundMessage();
            MuleEvent event = this.routeMessage(newMessage);
            MuleMessage muleMessage = returnedMessage = event == null ? null : event.getMessage();
            if (returnedMessage != null) {
                returnedMessage = returnedMessage.createInboundMessage();
            }
            return returnedMessage;
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
    }

    protected List<MuleMessage> getMessages() throws Exception {
        if (this.isReceiveMessagesInTransaction()) {
            MuleEvent message = this.getFirstMessage();
            if (message == null) {
                return null;
            }
            ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>(1);
            messages.add(message.getMessage());
            return messages;
        }
        return this.getFirstMessages();
    }

    protected List<MuleMessage> getFirstMessages() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        LinkedList<MuleMessage> messages = new LinkedList<MuleMessage>();
        int batchSize = this.getBatchSize(queue.size());
        MuleEvent message = (MuleEvent)queue.poll((long)this.connector.getQueueTimeout());
        if (message != null) {
            messages.add(message.getMessage());
            for (int i = 0; i < batchSize && message != null; ++i) {
                message = (MuleEvent)queue.poll(0L);
                if (message == null) continue;
                messages.add(message.getMessage());
            }
        }
        return messages;
    }

    protected MuleEvent getFirstMessage() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        return (MuleEvent)queue.poll((long)this.connector.getQueueTimeout());
    }

    protected void processMessage(Object msg) throws Exception {
        MuleMessage message = (MuleMessage)msg;
        MuleMessage newMessage = message.createInboundMessage();
        this.routeMessage(newMessage);
    }

    protected PollingReceiverWorker createWork() {
        return new ContinuousPollingReceiverWorker((AbstractPollingMessageReceiver)this);
    }
}

