/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.multipart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.mule.transport.http.multipart.MultiMap;
import org.mule.transport.http.multipart.MultipartConfiguration;
import org.mule.transport.http.multipart.Part;

public class MultiPartInputStream {
    public static final MultipartConfiguration __DEFAULT_MULTIPART_CONFIG = new MultipartConfiguration(System.getProperty("java.io.tmpdir"));
    protected InputStream _in;
    protected MultipartConfiguration _config;
    protected String _contentType;
    protected MultiMap _map;
    protected Map<String, Part> _parts;
    protected File _tmpDir;
    public static int CR = 13;
    public static int LF = 10;

    public MultiPartInputStream(InputStream in, String contentType, MultipartConfiguration config) {
        this._in = new BufferedInputStream(in);
        this._contentType = contentType;
        this._config = config;
        if (this._config == null) {
            this._config = __DEFAULT_MULTIPART_CONFIG;
        }
    }

    public Collection<Part> getParts() throws IOException {
        this.parse();
        return this._parts.values();
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.parse();
        return this._parts.get(name);
    }

    public MultiMap getMap() throws IOException, ServletException {
        this.parse();
        return this._map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() throws IOException {
        String line;
        if (this._parts != null) {
            return;
        }
        long total = 0L;
        this._parts = new HashMap<String, Part>();
        if (this._contentType == null || !this._contentType.startsWith("multipart/form-data")) {
            return;
        }
        String location = __DEFAULT_MULTIPART_CONFIG.getLocation();
        location = "".equals(this._config.getLocation()) ? location : this._config.getLocation();
        this._tmpDir = new File(location);
        if (!this._tmpDir.exists()) {
            this._tmpDir.mkdirs();
        }
        String boundary = "--" + this.value(this._contentType.substring(this._contentType.indexOf("boundary=")));
        byte[] byteBoundary = (boundary + "--").getBytes("ISO-8859-1");
        byte[] bytes = this.readLine(this._in);
        String string = line = bytes == null ? null : new String(bytes, "UTF-8");
        if (line == null || !line.equals(boundary)) {
            throw new IOException("Missing initial multi part boundary");
        }
        boolean lastPart = false;
        String contentDisposition = null;
        String contentType = null;
        block3: while (!lastPart) {
            MultiMap<String> headers = new MultiMap<String>();
            while ((bytes = this.readLine(this._in)) != null) {
                if (bytes.length != 0) {
                    if (this._config.getMaxRequestSize() > 0L && (total += (long)bytes.length) > this._config.getMaxRequestSize()) {
                        throw new IOException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                    }
                    line = new String(bytes, "UTF-8");
                    int c = line.indexOf(58, 0);
                    if (c <= 0) continue;
                    String key = line.substring(0, c).trim().toLowerCase();
                    String value = line.substring(c + 1, line.length()).trim();
                    headers.put(key, value);
                    if (key.equalsIgnoreCase("content-disposition")) {
                        contentDisposition = value;
                    }
                    if (!key.equalsIgnoreCase("content-type")) continue;
                    contentType = value;
                    continue;
                }
                boolean form_data = false;
                if (contentDisposition == null) {
                    throw new IOException("Missing content-disposition");
                }
                StringTokenizer tok = new StringTokenizer(contentDisposition, ";");
                String name = null;
                String filename = null;
                while (tok.hasMoreTokens()) {
                    String t = tok.nextToken().trim();
                    String tl = t.toLowerCase();
                    if (t.startsWith("form-data")) {
                        form_data = true;
                        continue;
                    }
                    if (tl.startsWith("name=")) {
                        name = this.value(t);
                        continue;
                    }
                    if (!tl.startsWith("filename=")) continue;
                    filename = this.value(t);
                }
                if (!form_data || name == null) continue block3;
                MultiPart part = new MultiPart(name, filename);
                part.setHeaders(headers);
                part.setContentType(contentType);
                this._parts.put(name, part);
                part.open();
                try {
                    int state = -2;
                    boolean cr = false;
                    boolean lf = false;
                    while (true) {
                        int c;
                        int b = 0;
                        while ((c = state != -2 ? state : this._in.read()) != -1) {
                            if (this._config.getMaxRequestSize() > 0L && ++total > this._config.getMaxRequestSize()) {
                                throw new IOException("Request exceeds maxRequestSize (" + this._config.getMaxRequestSize() + ")");
                            }
                            state = -2;
                            if (c == 13 || c == 10) {
                                if (c != 13) break;
                                state = this._in.read();
                                break;
                            }
                            if (b >= 0 && b < byteBoundary.length && c == byteBoundary[b]) {
                                ++b;
                                continue;
                            }
                            if (cr) {
                                part.write(13);
                            }
                            if (lf) {
                                part.write(10);
                            }
                            lf = false;
                            cr = false;
                            if (b > 0) {
                                part.write(byteBoundary, 0, b);
                            }
                            b = -1;
                            part.write(c);
                        }
                        if (b > 0 && b < byteBoundary.length - 2 || b == byteBoundary.length - 1) {
                            if (cr) {
                                part.write(13);
                            }
                            if (lf) {
                                part.write(10);
                            }
                            lf = false;
                            cr = false;
                            part.write(byteBoundary, 0, b);
                            b = -1;
                        }
                        if (b > 0 || c == -1) {
                            if (b == byteBoundary.length) {
                                lastPart = true;
                            }
                            if (state != 10) continue block3;
                            state = -2;
                            continue block3;
                        }
                        if (cr) {
                            part.write(13);
                        }
                        if (lf) {
                            part.write(10);
                        }
                        cr = c == 13;
                        boolean bl = lf = c == 10 || state == 10;
                        if (state != 10) continue;
                        state = -2;
                    }
                }
                finally {
                    part.close();
                    continue block3;
                }
            }
            break block3;
        }
    }

    private String value(String nameEqualsValue) {
        String value = nameEqualsValue.substring(nameEqualsValue.indexOf(61) + 1).trim();
        int i = value.indexOf(59);
        if (i > 0) {
            value = value.substring(0, i);
        }
        if (value.startsWith("\"")) {
            value = value.substring(1, value.indexOf(34, 1));
        } else {
            i = value.indexOf(32);
            if (i > 0) {
                value = value.substring(0, i);
            }
        }
        return value;
    }

    private byte[] readLine(InputStream in) throws IOException {
        byte[] old_buf;
        byte[] buf = new byte[256];
        int i = 0;
        int loops = 0;
        int ch = 0;
        while ((ch = in.read()) >= 0) {
            if (++loops == 1 && ch == LF) continue;
            if (ch == CR || ch == LF) break;
            if (i >= buf.length) {
                old_buf = buf;
                buf = new byte[old_buf.length + 256];
                System.arraycopy(old_buf, 0, buf, 0, old_buf.length);
            }
            buf[i++] = (byte)ch;
        }
        if (ch == -1 && i == 0) {
            return null;
        }
        if (ch == CR && in.available() >= 1 && in.markSupported()) {
            in.mark(1);
            ch = in.read();
            if (ch != LF) {
                in.reset();
            }
        }
        old_buf = buf;
        buf = new byte[i];
        System.arraycopy(old_buf, 0, buf, 0, i);
        return buf;
    }

    public class MultiPart
    implements Part {
        protected String _name;
        protected String _filename;
        protected File _file;
        protected OutputStream _out;
        protected String _contentType;
        protected MultiMap<String> _headers;
        protected long _size = 0L;

        public MultiPart(String name, String filename) throws IOException {
            this._name = name;
            this._filename = filename;
        }

        protected void setContentType(String contentType) {
            this._contentType = contentType;
        }

        protected void open() throws FileNotFoundException, IOException {
            if (this._filename != null && this._filename.trim().length() > 0) {
                this.createFile();
            } else {
                this._out = new ByteArrayOutputStream();
            }
        }

        protected void close() throws IOException {
            this._out.close();
        }

        protected void write(int b) throws IOException {
            if (MultiPartInputStream.this._config.getMaxFileSize() > 0L && this._size + 1L > MultiPartInputStream.this._config.getMaxFileSize()) {
                throw new IOException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartInputStream.this._config.getFileSizeThreshold() > 0 && this._size + 1L > (long)MultiPartInputStream.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(b);
            ++this._size;
        }

        protected void write(byte[] bytes, int offset, int length) throws IOException {
            if (MultiPartInputStream.this._config.getMaxFileSize() > 0L && this._size + (long)length > MultiPartInputStream.this._config.getMaxFileSize()) {
                throw new IOException("Multipart Mime part " + this._name + " exceeds max filesize");
            }
            if (MultiPartInputStream.this._config.getFileSizeThreshold() > 0 && this._size + (long)length > (long)MultiPartInputStream.this._config.getFileSizeThreshold() && this._file == null) {
                this.createFile();
            }
            this._out.write(bytes, offset, length);
            this._size += (long)length;
        }

        protected void createFile() throws IOException {
            this._file = File.createTempFile("MultiPart", "", MultiPartInputStream.this._tmpDir);
            FileOutputStream fos = new FileOutputStream(this._file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            if (this._size > 0L && this._out != null) {
                this._out.flush();
                ((ByteArrayOutputStream)this._out).writeTo(bos);
                this._out.close();
            }
            this._out = bos;
        }

        protected void setHeaders(MultiMap<String> headers) {
            this._headers = headers;
        }

        @Override
        public String getContentType() {
            return this._contentType;
        }

        @Override
        public String getHeader(String name) {
            return (String)this._headers.getValue(name, 0);
        }

        @Override
        public Collection<String> getHeaderNames() {
            return this._headers.keySet();
        }

        @Override
        public Collection<String> getHeaders(String name) {
            return this._headers.getValues(name);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
            return new ByteArrayInputStream(((ByteArrayOutputStream)this._out).toByteArray());
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public long getSize() {
            return this._size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(String fileName) throws IOException {
            if (this._file == null) {
                this._file = new File(MultiPartInputStream.this._tmpDir, fileName);
                FilterOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(this._file));
                    ((ByteArrayOutputStream)this._out).writeTo(bos);
                    ((BufferedOutputStream)bos).flush();
                }
                finally {
                    if (bos != null) {
                        bos.close();
                    }
                }
            } else {
                this._file.renameTo(new File(MultiPartInputStream.this._tmpDir, fileName));
            }
        }

        @Override
        public void delete() throws IOException {
            if (this._file != null) {
                this._file.delete();
            }
        }

        public File getFile() {
            return this._file;
        }

        public String getContentDispositionFilename() {
            return this._filename;
        }
    }
}

